/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.docker.editor.ls;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.embedder.node.NodeJSManager;

public class InitializeLaunchConfigurations {
    private static boolean alreadyWarned;

    public static String getNodeJsLocation() {
        File nodeJsRuntime = NodeJSManager.getNodeJsLocation();
        if (nodeJsRuntime != null) {
            return nodeJsRuntime.getAbsolutePath();
        }
        String res = null;
        String[] command = new String[]{"/bin/bash", "-c", "which node"};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where node"};
        }
        BufferedReader reader = null;
        try {
            Process p = Runtime.getRuntime().exec(command);
            reader = p.inputReader();
            res = reader.readLine();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (res == null && Platform.getOS().equals("macosx")) {
            res = "/usr/local/bin/node";
        }
        if (res != null && Files.exists(Paths.get(res, new String[0]), new LinkOption[0])) {
            return res;
        }
        if (!alreadyWarned) {
            InitializeLaunchConfigurations.warnNodeJSMissing();
            alreadyWarned = true;
        }
        return null;
    }

    private static void warnNodeJSMissing() {
        Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Missing node.js", (String)"Could not find node.js. This will result in editors missing key features.\nPlease make sure node.js is installed and that your PATH environement variable contains the location to the `node` executable."));
    }
}

