/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.ui.wizards;

import java.util.regex.Matcher;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.docker.core.DockerImage;
import org.eclipse.linuxtools.internal.docker.ui.wizards.WizardMessages;

public class ImageNameValidator
implements IValidator<String> {
    public IStatus validate(String imageName) {
        ImageNameStatus imageNameStatus = ImageNameValidator.getStatus(imageName);
        switch (imageNameStatus.ordinal()) {
            case 1: {
                return ValidationStatus.cancel((String)WizardMessages.getString("ImagePull.desc"));
            }
            case 2: {
                return ValidationStatus.warning((String)WizardMessages.getString("ImagePull.name.invalidformat.msg"));
            }
            case 3: {
                return ValidationStatus.warning((String)WizardMessages.getString("ImagePull.assumeLatest.msg"));
            }
        }
        return Status.OK_STATUS;
    }

    public static ImageNameStatus getStatus(String imageName) {
        if (imageName == null || imageName.isEmpty()) {
            return ImageNameStatus.EMPTY;
        }
        Matcher matcher = DockerImage.imageNamePattern.matcher(imageName);
        if (!matcher.matches()) {
            return ImageNameStatus.INVALID_FORMAT;
        }
        if (matcher.group("tag") == null) {
            return ImageNameStatus.TAG_MISSING;
        }
        return ImageNameStatus.VALID;
    }

    public static enum ImageNameStatus {
        VALID,
        EMPTY,
        INVALID_FORMAT,
        TAG_MISSING;

    }
}

