/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.identity;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.kura.identity.IdentityConfigurationComponent;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class IdentityConfiguration {
    private final String name;
    private final List<IdentityConfigurationComponent> components;

    public IdentityConfiguration(String name, List<IdentityConfigurationComponent> components) {
        this.name = Objects.requireNonNull(name, "name cannot be null");
        if (this.name.trim().isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.components = Objects.requireNonNull(components, "components cannot be null");
    }

    public String getName() {
        return this.name;
    }

    public List<IdentityConfigurationComponent> getComponents() {
        return this.components;
    }

    public <T extends IdentityConfigurationComponent> Optional<T> getComponent(Class<T> clazz) {
        for (IdentityConfigurationComponent component : this.components) {
            if (!clazz.isInstance(component)) continue;
            return Optional.of((IdentityConfigurationComponent)clazz.cast(component));
        }
        return Optional.empty();
    }

    public int hashCode() {
        return Objects.hash(this.components, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IdentityConfiguration)) {
            return false;
        }
        IdentityConfiguration other = (IdentityConfiguration)obj;
        return Objects.equals(this.components, other.components) && Objects.equals(this.name, other.name);
    }
}

