/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui.network;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.BlurEvent;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseOverEvent;
import com.google.gwt.event.dom.client.MouseOverHandler;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.SelectionChangeEvent;
import com.google.gwt.view.client.SingleSelectionModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.client.ui.network.NetworkTab;
import org.eclipse.kura.web.client.ui.network.NetworkTabsUi;
import org.eclipse.kura.web.client.ui.network.TabTcpIpUi;
import org.eclipse.kura.web.client.util.FailureHandler;
import org.eclipse.kura.web.client.util.GwtSafeHtmlUtils;
import org.eclipse.kura.web.client.util.HelpButton;
import org.eclipse.kura.web.client.util.MessageUtils;
import org.eclipse.kura.web.shared.model.GwtGroupedNVPair;
import org.eclipse.kura.web.shared.model.GwtNetIfStatus;
import org.eclipse.kura.web.shared.model.GwtNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtSession;
import org.eclipse.kura.web.shared.model.GwtWifiBgscanModule;
import org.eclipse.kura.web.shared.model.GwtWifiChannelModel;
import org.eclipse.kura.web.shared.model.GwtWifiCiphers;
import org.eclipse.kura.web.shared.model.GwtWifiConfig;
import org.eclipse.kura.web.shared.model.GwtWifiHotspotEntry;
import org.eclipse.kura.web.shared.model.GwtWifiNetInterfaceConfig;
import org.eclipse.kura.web.shared.model.GwtWifiRadioMode;
import org.eclipse.kura.web.shared.model.GwtWifiSecurity;
import org.eclipse.kura.web.shared.model.GwtWifiWirelessMode;
import org.eclipse.kura.web.shared.model.GwtXSRFToken;
import org.eclipse.kura.web.shared.service.GwtDeviceService;
import org.eclipse.kura.web.shared.service.GwtDeviceServiceAsync;
import org.eclipse.kura.web.shared.service.GwtNetworkService;
import org.eclipse.kura.web.shared.service.GwtNetworkServiceAsync;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenService;
import org.eclipse.kura.web.shared.service.GwtSecurityTokenServiceAsync;
import org.gwtbootstrap3.client.ui.Alert;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.FormGroup;
import org.gwtbootstrap3.client.ui.FormLabel;
import org.gwtbootstrap3.client.ui.HelpBlock;
import org.gwtbootstrap3.client.ui.InlineRadio;
import org.gwtbootstrap3.client.ui.Input;
import org.gwtbootstrap3.client.ui.ListBox;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.PanelHeader;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ValidationState;
import org.gwtbootstrap3.client.ui.gwt.CellTable;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;

public class TabWirelessUi
extends Composite
implements NetworkTab {
    private static final String NET_WIFI_WIRELESS_MODE_STATION = "netWifiWirelessModeStation";
    private static final String WIFI_MODE_STATION = GwtWifiWirelessMode.netWifiWirelessModeStation.name();
    private static final String WIFI_MODE_STATION_MESSAGE = MessageUtils.get(WIFI_MODE_STATION);
    private static final String WIFI_SECURITY_WEP_MESSAGE = MessageUtils.get(GwtWifiSecurity.netWifiSecurityWEP.name());
    private static final String WIFI_SECURITY_WPA_MESSAGE = MessageUtils.get(GwtWifiSecurity.netWifiSecurityWPA.name());
    private static final String WIFI_SECURITY_WPA2_MESSAGE = MessageUtils.get(GwtWifiSecurity.netWifiSecurityWPA2.name());
    private static final String WIFI_BGSCAN_NONE_MESSAGE = MessageUtils.get(GwtWifiBgscanModule.netWifiBgscanMode_NONE.name());
    private static final String WIFI_CIPHERS_CCMP_TKIP_MESSAGE = MessageUtils.get(GwtWifiCiphers.netWifiCiphers_CCMP_TKIP.name());
    private static final String WIFI_RADIO_BGN_MESSAGE = MessageUtils.get(GwtWifiRadioMode.netWifiRadioModeBGN.name());
    private static final String WIFI_SECURITY_NONE_MESSAGE = MessageUtils.get(GwtWifiSecurity.netWifiSecurityNONE.name());
    private static final String IPV4_STATUS_WAN_MESSAGE = MessageUtils.get(GwtNetIfStatus.netIPv4StatusEnabledWAN.name());
    private static final String WIFI_MODE_ACCESS_POINT_MESSAGE = MessageUtils.get(GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.name());
    private static TabWirelessUiUiBinder uiBinder = (TabWirelessUiUiBinder)GWT.create(TabWirelessUiUiBinder.class);
    private static final Logger logger = Logger.getLogger(TabWirelessUi.class.getSimpleName());
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);
    private final GwtSecurityTokenServiceAsync gwtXSRFService = (GwtSecurityTokenServiceAsync)GWT.create(GwtSecurityTokenService.class);
    private final GwtNetworkServiceAsync gwtNetworkService = (GwtNetworkServiceAsync)GWT.create(GwtNetworkService.class);
    private final GwtDeviceServiceAsync gwtDeviceService = (GwtDeviceServiceAsync)GWT.create(GwtDeviceService.class);
    private static final String REGEX_PASSWORD_ANY = ".*";
    private static final String REGEX_PASSWORD_WPA = "^[ -~]{8,63}$";
    private static final String REGEX_PASSWORD_WEP = "^(?:\\w{5}|\\w{13}|[a-fA-F0-9]{10}|[a-fA-F0-9]{26})$";
    private static final int MAX_WIFI_CHANNEL = 13;
    private static final int MAX_SSID_LENGTH = 32;
    private final GwtSession session;
    private final TabTcpIpUi tcpTab;
    private final NetworkTabsUi netTabs;
    private final ListDataProvider<GwtWifiHotspotEntry> ssidDataProvider = new ListDataProvider();
    private final SingleSelectionModel<GwtWifiHotspotEntry> ssidSelectionModel = new SingleSelectionModel();
    private final ListDataProvider<GwtWifiChannelModel> channelDataProvider = new ListDataProvider();
    private final SingleSelectionModel<GwtWifiChannelModel> selectionModel = new SingleSelectionModel();
    private boolean dirty;
    private boolean ssidInit = false;
    private GwtWifiNetInterfaceConfig selectedNetIfConfig;
    private String passwordRegex;
    private String passwordError;
    private String tcpStatus;
    GwtWifiConfig activeConfig;
    @UiField
    CellTable<GwtWifiChannelModel> channelGrid = new CellTable();
    @UiField
    Alert noChannels;
    @UiField
    Text noChannelsText;
    @UiField
    FormLabel labelWireless;
    @UiField
    FormLabel labelSsid;
    @UiField
    FormLabel labelRadio;
    @UiField
    FormLabel labelSecurity;
    @UiField
    FormLabel labelPassword;
    @UiField
    FormLabel labelVerify;
    @UiField
    FormLabel labelPairwise;
    @UiField
    FormLabel labelGroup;
    @UiField
    FormLabel labelBgscan;
    @UiField
    FormLabel labelRssi;
    @UiField
    FormLabel labelShortI;
    @UiField
    FormLabel labelLongI;
    @UiField
    FormLabel labelPing;
    @UiField
    FormLabel labelIgnore;
    @UiField
    InlineRadio radio1;
    @UiField
    InlineRadio radio2;
    @UiField
    InlineRadio radio3;
    @UiField
    InlineRadio radio4;
    @UiField
    ListBox wireless;
    @UiField
    ListBox radio;
    @UiField
    ListBox security;
    @UiField
    ListBox pairwise;
    @UiField
    ListBox group;
    @UiField
    ListBox bgscan;
    @UiField
    TextBox ssid;
    @UiField
    TextBox shortI;
    @UiField
    TextBox longI;
    @UiField
    Input password;
    @UiField
    Input verify;
    @UiField
    TextBox rssi;
    @UiField
    PanelHeader helpTitle;
    @UiField
    ScrollPanel helpText;
    @UiField
    Button buttonSsid;
    @UiField
    Button buttonPassword;
    @UiField
    FormGroup groupVerify;
    @UiField
    FormGroup groupRssi;
    @UiField
    FormGroup groupPassword;
    @UiField
    FormGroup groupWireless;
    @UiField
    FormGroup groupShortI;
    @UiField
    FormGroup groupLongI;
    @UiField
    HelpBlock helpWireless;
    @UiField
    HelpBlock helpPassword;
    @UiField
    HelpBlock helpVerify;
    @UiField
    Modal ssidModal;
    @UiField
    PanelHeader ssidTitle;
    @UiField
    CellTable<GwtWifiHotspotEntry> ssidGrid = new CellTable();
    @UiField
    Alert searching;
    @UiField
    Alert noSsid;
    @UiField
    Alert scanFail;
    @UiField
    Text searchingText;
    @UiField
    Text noSsidText;
    @UiField
    Text scanFailText;
    @UiField
    HelpButton wirelessHelp;
    @UiField
    HelpButton ssidHelp;
    @UiField
    HelpButton radioHelp;
    @UiField
    HelpButton securityHelp;
    @UiField
    HelpButton passwordHelp;
    @UiField
    HelpButton verifyHelp;
    @UiField
    HelpButton pairwiseHelp;
    @UiField
    HelpButton groupHelp;
    @UiField
    HelpButton bgscanHelp;
    @UiField
    HelpButton rssiHelp;
    @UiField
    HelpButton shortIHelp;
    @UiField
    HelpButton longIHelp;
    @UiField
    HelpButton pingHelp;
    @UiField
    HelpButton ignoreHelp;

    public TabWirelessUi(GwtSession currentSession, TabTcpIpUi tcp, NetworkTabsUi tabs) {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.session = currentSession;
        this.tcpTab = tcp;
        this.netTabs = tabs;
        this.initForm();
        this.initHelpButtons();
        this.setPasswordValidation();
        this.tcpTab.status.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                String tcpIpStatus;
                if (TabWirelessUi.this.selectedNetIfConfig != null && !(tcpIpStatus = TabWirelessUi.this.tcpTab.getStatus()).equals(TabWirelessUi.this.tcpStatus)) {
                    TabWirelessUi.this.activeConfig = tcpIpStatus.equals(MessageUtils.get(GwtNetIfStatus.netIPv4StatusEnabledWAN.name())) ? TabWirelessUi.this.selectedNetIfConfig.getStationWifiConfig() : TabWirelessUi.this.selectedNetIfConfig.getActiveWifiConfig();
                    TabWirelessUi.this.tcpStatus = tcpIpStatus;
                    TabWirelessUi.this.netTabs.adjustInterfaceTabs();
                }
                TabWirelessUi.this.update();
            }
        });
    }

    @UiHandler(value={"wireless", "ssid", "radio", "security", "password", "verify", "pairwise", "group", "bgscan", "longI", "shortI", "radio1", "radio2", "radio3", "radio4", "rssi"})
    public void onFormBlur(BlurEvent e) {
        this.setDirty(true);
    }

    public GwtWifiWirelessMode getWirelessMode() {
        if (this.wireless != null) {
            GwtWifiWirelessMode[] gwtWifiWirelessModeArray = GwtWifiWirelessMode.values();
            int n = gwtWifiWirelessModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GwtWifiWirelessMode mode = gwtWifiWirelessModeArray[n2];
                if (this.wireless.getSelectedItemText().equals(MessageUtils.get(mode.name()))) {
                    return mode;
                }
                ++n2;
            }
        } else if (this.activeConfig != null) {
            return GwtWifiWirelessMode.valueOf(this.activeConfig.getWirelessMode());
        }
        return null;
    }

    @Override
    public void setDirty(boolean flag) {
        this.dirty = flag;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public boolean isValid() {
        boolean result = false;
        result = !this.isValidForm();
        return result;
    }

    private boolean isValidForm() {
        boolean result = this.groupWireless.getValidationState().equals((Object)ValidationState.ERROR) || this.groupPassword.getValidationState().equals((Object)ValidationState.ERROR) || this.groupVerify.getValidationState().equals((Object)ValidationState.ERROR);
        result = result || this.groupRssi.getValidationState().equals((Object)ValidationState.ERROR) || this.groupShortI.getValidationState().equals((Object)ValidationState.ERROR) || this.groupLongI.getValidationState().equals((Object)ValidationState.ERROR);
        return result;
    }

    @Override
    public void setNetInterface(GwtNetInterfaceConfig config) {
        this.setDirty(true);
        if (this.tcpStatus == null || this.selectedNetIfConfig != config) {
            this.tcpStatus = this.tcpTab.getStatus();
        }
        if (config instanceof GwtWifiNetInterfaceConfig) {
            this.selectedNetIfConfig = (GwtWifiNetInterfaceConfig)config;
            this.activeConfig = this.selectedNetIfConfig.getActiveWifiConfig();
        }
    }

    @Override
    public void refresh() {
        if (this.isDirty()) {
            this.setDirty(false);
            if (this.selectedNetIfConfig == null) {
                this.reset();
            } else {
                this.update();
            }
        }
    }

    @Override
    public void getUpdatedNetInterface(GwtNetInterfaceConfig updatedNetIf) {
        GwtWifiNetInterfaceConfig updatedWifiNetIf = (GwtWifiNetInterfaceConfig)updatedNetIf;
        if (this.session != null) {
            GwtWifiConfig updatedWifiConfig = this.getGwtWifiConfig();
            updatedWifiNetIf.setWirelessMode(updatedWifiConfig.getWirelessMode());
            updatedWifiNetIf.setWifiConfig(updatedWifiConfig);
        } else if (this.selectedNetIfConfig != null) {
            updatedWifiNetIf.setAccessPointWifiConfig(this.selectedNetIfConfig.getAccessPointWifiConfigProps());
            updatedWifiNetIf.setStationWifiConfig(this.selectedNetIfConfig.getStationWifiConfigProps());
            GwtWifiWirelessMode[] gwtWifiWirelessModeArray = GwtWifiWirelessMode.values();
            int n = gwtWifiWirelessModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GwtWifiWirelessMode mode = gwtWifiWirelessModeArray[n2];
                if (mode.name().equals(this.selectedNetIfConfig.getWirelessMode())) {
                    updatedWifiNetIf.setWirelessMode(mode.name());
                }
                ++n2;
            }
        }
    }

    private void update() {
        this.setValues();
        this.refreshForm();
    }

    private void setValues() {
        String activeBgscanModule;
        String activeGroupCiphers;
        String activePairwiseCiphers;
        int channel2;
        if (this.activeConfig == null) {
            return;
        }
        int i = 0;
        while (i < this.wireless.getItemCount()) {
            if (this.wireless.getItemText(i).equals(MessageUtils.get(this.activeConfig.getWirelessMode()))) {
                this.wireless.setSelectedIndex(i);
            }
            ++i;
        }
        this.ssid.setValue((Object)GwtSafeHtmlUtils.htmlUnescape(this.activeConfig.getWirelessSsid()));
        String activeRadioMode = this.activeConfig.getRadioMode();
        if (activeRadioMode != null) {
            int i2 = 0;
            while (i2 < this.radio.getItemCount()) {
                if (this.radio.getItemText(i2).equals(MessageUtils.get(activeRadioMode))) {
                    this.radio.setSelectedIndex(i2);
                    break;
                }
                ++i2;
            }
        }
        List<Integer> alChannels = this.activeConfig.getChannels();
        int channelListSize = this.channelDataProvider.getList().size();
        int maxIndex = Math.min(channelListSize, 13);
        if (alChannels != null && !alChannels.isEmpty()) {
            channel2 = 1;
            while (channel2 <= maxIndex) {
                this.selectionModel.setSelected((Object)((GwtWifiChannelModel)this.channelDataProvider.getList().get(channel2 - 1)), false);
                ++channel2;
            }
            for (int channel2 : alChannels) {
                if (channel2 > maxIndex) continue;
                this.selectionModel.setSelected((Object)((GwtWifiChannelModel)this.channelDataProvider.getList().get(channel2 - 1)), true);
            }
        } else {
            logger.info("No channels specified, selecting all ...");
            channel2 = 1;
            while (channel2 <= maxIndex) {
                this.selectionModel.setSelected((Object)((GwtWifiChannelModel)this.channelDataProvider.getList().get(channel2 - 1)), true);
                ++channel2;
            }
        }
        String activeSecurity = this.activeConfig.getSecurity();
        if (activeSecurity != null) {
            int i3 = 0;
            while (i3 < this.security.getItemCount()) {
                if (this.security.getItemText(i3).equals(MessageUtils.get(activeSecurity))) {
                    this.security.setSelectedIndex(i3);
                    break;
                }
                ++i3;
            }
        }
        if ((activePairwiseCiphers = this.activeConfig.getPairwiseCiphers()) != null) {
            int i4 = 0;
            while (i4 < this.pairwise.getItemCount()) {
                if (this.pairwise.getItemText(i4).equals(MessageUtils.get(activePairwiseCiphers))) {
                    this.pairwise.setSelectedIndex(i4);
                    break;
                }
                ++i4;
            }
        }
        if ((activeGroupCiphers = this.activeConfig.getPairwiseCiphers()) != null) {
            int i5 = 0;
            while (i5 < this.group.getItemCount()) {
                if (this.group.getItemText(i5).equals(MessageUtils.get(activeGroupCiphers))) {
                    this.group.setSelectedIndex(i5);
                    break;
                }
                ++i5;
            }
        }
        if ((activeBgscanModule = this.activeConfig.getBgscanModule()) != null) {
            int i6 = 0;
            while (i6 < this.bgscan.getItemCount()) {
                if (this.bgscan.getItemText(i6).equals(MessageUtils.get(activeBgscanModule))) {
                    this.bgscan.setSelectedIndex(i6);
                    break;
                }
                ++i6;
            }
        }
        this.rssi.setValue((Object)"90");
        this.shortI.setValue((Object)String.valueOf(this.activeConfig.getBgscanShortInterval()));
        this.longI.setValue((Object)String.valueOf(this.activeConfig.getBgscanLongInterval()));
        this.password.setValue((Object)this.activeConfig.getPassword());
        this.verify.setValue((Object)this.activeConfig.getPassword());
        this.radio1.setValue(Boolean.valueOf(this.activeConfig.pingAccessPoint()));
        this.radio2.setValue(Boolean.valueOf(!this.activeConfig.pingAccessPoint()));
        this.radio3.setValue(Boolean.valueOf(this.activeConfig.ignoreSSID()));
        this.radio4.setValue(Boolean.valueOf(!this.activeConfig.ignoreSSID()));
    }

    private void refreshForm() {
        logger.info("refreshForm()");
        String tcpipStatus = this.tcpTab.getStatus();
        if (tcpipStatus.equals(GwtNetIfStatus.netIPv4StatusDisabled.name())) {
            this.setForm(false);
        } else {
            this.setForm(true);
            if (WIFI_MODE_STATION_MESSAGE.equals(this.wireless.getSelectedItemText())) {
                if (tcpipStatus.equals(IPV4_STATUS_WAN_MESSAGE)) {
                    this.wireless.setEnabled(false);
                }
                this.radio.setEnabled(false);
                this.groupVerify.setVisible(false);
            } else if (WIFI_MODE_ACCESS_POINT_MESSAGE.equals(this.wireless.getSelectedItemText())) {
                if (tcpipStatus.equals(IPV4_STATUS_WAN_MESSAGE)) {
                    this.setForm(false);
                }
                this.radio.setEnabled(true);
                this.groupVerify.setVisible(true);
            }
            if (this.security.getSelectedItemText().equals(WIFI_SECURITY_NONE_MESSAGE)) {
                this.password.setEnabled(false);
                this.verify.setEnabled(false);
                this.buttonPassword.setEnabled(false);
            }
            if (WIFI_MODE_STATION_MESSAGE.equals(this.wireless.getSelectedItemText())) {
                this.ssid.setEnabled(true);
                if (!this.security.getSelectedItemText().equals(WIFI_SECURITY_NONE_MESSAGE)) {
                    if (this.password.getValue() != null && ((String)this.password.getValue()).length() > 0) {
                        this.password.setEnabled(true);
                        this.buttonPassword.setEnabled(true);
                    } else {
                        this.password.setEnabled(true);
                        this.buttonPassword.setEnabled(false);
                    }
                }
                this.bgscan.setEnabled(true);
                if (this.bgscan.getSelectedItemText().equals(MessageUtils.get(GwtWifiBgscanModule.netWifiBgscanMode_SIMPLE.name())) || this.bgscan.getSelectedItemText().equals(MessageUtils.get(GwtWifiBgscanModule.netWifiBgscanMode_LEARN.name()))) {
                    this.shortI.setEnabled(true);
                    this.longI.setEnabled(true);
                } else {
                    this.shortI.setEnabled(false);
                    this.longI.setEnabled(false);
                }
            } else {
                this.ssid.setEnabled(true);
                this.buttonSsid.setEnabled(false);
                if (!this.security.getSelectedItemText().equals(WIFI_SECURITY_NONE_MESSAGE)) {
                    this.password.setEnabled(true);
                    this.buttonPassword.setEnabled(false);
                }
                this.bgscan.setEnabled(false);
                this.rssi.setEnabled(false);
                this.shortI.setEnabled(false);
                this.longI.setEnabled(false);
                this.radio1.setEnabled(false);
                this.radio2.setEnabled(false);
            }
            if (this.security.getSelectedItemText().equals(WIFI_SECURITY_WPA2_MESSAGE) || this.security.getSelectedItemText().equals(WIFI_SECURITY_WPA_MESSAGE) || this.security.getSelectedItemText().equals(MessageUtils.get(GwtWifiSecurity.netWifiSecurityWPA_WPA2.name()))) {
                if (WIFI_MODE_STATION_MESSAGE.equals(this.wireless.getSelectedItemText())) {
                    this.pairwise.setEnabled(true);
                    this.group.setEnabled(true);
                } else {
                    this.pairwise.setEnabled(true);
                    this.group.setEnabled(false);
                }
            } else {
                this.pairwise.setEnabled(false);
                this.group.setEnabled(false);
            }
        }
        this.netTabs.adjustInterfaceTabs();
    }

    private void reset() {
        int i = 0;
        while (i < this.wireless.getItemCount()) {
            if (this.wireless.getSelectedItemText().equals(WIFI_MODE_STATION_MESSAGE)) {
                this.wireless.setSelectedIndex(i);
            }
            ++i;
        }
        this.ssid.setText("");
        i = 0;
        while (i < this.radio.getItemCount()) {
            if (this.radio.getItemText(i).equals(WIFI_RADIO_BGN_MESSAGE)) {
                this.radio.setSelectedIndex(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.security.getItemCount()) {
            if (this.security.getItemText(i).equals(WIFI_SECURITY_WPA2_MESSAGE)) {
                this.security.setSelectedIndex(i);
            }
            ++i;
        }
        this.password.setText("");
        this.verify.setText("");
        i = 0;
        while (i < this.pairwise.getItemCount()) {
            if (this.pairwise.getItemText(i).equals(WIFI_CIPHERS_CCMP_TKIP_MESSAGE)) {
                this.pairwise.setSelectedIndex(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.group.getItemCount()) {
            if (this.group.getItemText(i).equals(WIFI_CIPHERS_CCMP_TKIP_MESSAGE)) {
                this.group.setSelectedIndex(i);
            }
            ++i;
        }
        i = 0;
        while (i < this.bgscan.getItemCount()) {
            if (this.bgscan.getItemText(i).equals(WIFI_BGSCAN_NONE_MESSAGE)) {
                this.bgscan.setSelectedIndex(i);
            }
            ++i;
        }
        this.rssi.setValue((Object)"0.0");
        this.shortI.setValue((Object)"");
        this.longI.setValue((Object)"");
        this.radio2.setValue(Boolean.valueOf(true));
        this.radio4.setValue(Boolean.valueOf(true));
        this.update();
    }

    private void initHelpButtons() {
        this.wirelessHelp.setHelpTextProvider(new HelpButton.HelpTextProvider(){

            @Override
            public String getHelpText() {
                if (TabWirelessUi.this.wireless.getSelectedItemText().equals(MessageUtils.get(TabWirelessUi.NET_WIFI_WIRELESS_MODE_STATION))) {
                    return MSGS.netWifiToolTipWirelessModeStation();
                }
                return MSGS.netWifiToolTipWirelessModeAccessPoint();
            }
        });
        this.ssidHelp.setHelpText(MSGS.netWifiToolTipNetworkName());
        this.radioHelp.setHelpText(MSGS.netWifiToolTipRadioMode());
        this.securityHelp.setHelpText(MSGS.netWifiToolTipSecurity());
        this.passwordHelp.setHelpText(MSGS.netWifiToolTipPassword());
        this.verifyHelp.setHelpText(MSGS.netWifiToolTipPassword());
        this.pairwiseHelp.setHelpText(MSGS.netWifiToolTipPairwiseCiphers());
        this.groupHelp.setHelpText(MSGS.netWifiToolTipGroupCiphers());
        this.bgscanHelp.setHelpText(MSGS.netWifiToolTipBgScan());
        this.rssiHelp.setHelpText(MSGS.netWifiToolTipBgScanStrength());
        this.shortIHelp.setHelpText(MSGS.netWifiToolTipBgScanShortInterval());
        this.longIHelp.setHelpText(MSGS.netWifiToolTipBgScanLongInterval());
        this.pingHelp.setHelpText(MSGS.netWifiToolTipPingAccessPoint());
        this.ignoreHelp.setHelpText(MSGS.netWifiToolTipIgnoreSSID());
    }

    private void initForm() {
        Enum ciphers;
        Enum mode;
        this.labelWireless.setText(MSGS.netWifiWirelessMode());
        this.wireless.addItem(MessageUtils.get(NET_WIFI_WIRELESS_MODE_STATION));
        this.wireless.addItem(MessageUtils.get("netWifiWirelessModeAccessPoint"));
        this.wireless.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.wireless.getSelectedItemText().equals(MessageUtils.get(TabWirelessUi.NET_WIFI_WIRELESS_MODE_STATION))) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipWirelessModeStation()));
                } else {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipWirelessModeAccessPoint()));
                }
            }
        });
        this.wireless.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.wireless.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabWirelessUi.this.helpWireless.setText("");
                TabWirelessUi.this.groupWireless.setValidationState(ValidationState.NONE);
                TabWirelessUi.this.activeConfig = TabWirelessUi.this.wireless.getSelectedItemText().equals(WIFI_MODE_STATION_MESSAGE) ? TabWirelessUi.this.selectedNetIfConfig.getStationWifiConfig() : TabWirelessUi.this.selectedNetIfConfig.getAccessPointWifiConfig();
                TabWirelessUi.this.netTabs.adjustInterfaceTabs();
                TabWirelessUi.this.setPasswordValidation();
                TabWirelessUi.this.update();
                TabWirelessUi.this.wirelessHelp.updateHelpText();
            }
        });
        this.labelSsid.setText(MSGS.netWifiNetworkName());
        this.ssid.setMaxLength(32);
        this.ssid.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.ssid.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipNetworkName()));
                }
            }
        });
        this.ssid.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.buttonSsid.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (!TabWirelessUi.this.ssidInit) {
                    TabWirelessUi.this.initSsid();
                    TabWirelessUi.this.ssidDataProvider.getList().clear();
                    TabWirelessUi.this.searching.setVisible(true);
                    TabWirelessUi.this.noSsid.setVisible(false);
                    TabWirelessUi.this.ssidGrid.setVisible(false);
                    TabWirelessUi.this.scanFail.setVisible(false);
                }
                TabWirelessUi.this.initModal();
                TabWirelessUi.this.loadSsidData();
            }
        });
        this.labelRadio.setText(MSGS.netWifiRadioMode());
        this.radio.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.radio.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipRadioMode()));
                }
            }
        });
        this.radio.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        Enum[] enumArray = GwtWifiRadioMode.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            mode = enumArray[n2];
            if (mode != GwtWifiRadioMode.netWifiRadioModeA) {
                this.radio.addItem(MessageUtils.get(mode.name()));
            }
            ++n2;
        }
        this.labelSecurity.setText(MSGS.netWifiWirelessSecurity());
        this.security.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.security.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipSecurity()));
                }
            }
        });
        this.security.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        enumArray = GwtWifiSecurity.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            mode = enumArray[n2];
            this.security.addItem(MessageUtils.get(mode.name()));
            ++n2;
        }
        this.security.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabWirelessUi.this.setPasswordValidation();
                TabWirelessUi.this.refreshForm();
                TabWirelessUi.this.checkPassword();
            }
        });
        this.labelPassword.setText(MSGS.netWifiWirelessPassword());
        this.password.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.password.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipPassword()));
                }
            }
        });
        this.password.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.buttonPassword.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                EntryClassUi.showWaitModal();
                TabWirelessUi.this.buttonPassword.setEnabled(false);
                final GwtWifiConfig gwtWifiConfig = TabWirelessUi.this.getGwtWifiConfig();
                TabWirelessUi.this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                    public void onFailure(Throwable ex) {
                        FailureHandler.handle(ex);
                    }

                    public void onSuccess(GwtXSRFToken token) {
                        TabWirelessUi.this.gwtNetworkService.verifyWifiCredentials(token, TabWirelessUi.this.selectedNetIfConfig.getName(), gwtWifiConfig, new AsyncCallback<Boolean>(){

                            public void onFailure(Throwable caught) {
                                FailureHandler.handle(caught);
                                EntryClassUi.hideWaitModal();
                                ((this).this).TabWirelessUi.this.buttonPassword.setEnabled(true);
                                TabWirelessUi.this.showPasswordVerificationStatus(MSGS.netWifiPasswordVerificationFailed());
                            }

                            public void onSuccess(Boolean result) {
                                if (!result.booleanValue()) {
                                    TabWirelessUi.this.showPasswordVerificationStatus(MSGS.netWifiPasswordVerificationFailed());
                                } else {
                                    TabWirelessUi.this.showPasswordVerificationStatus(MSGS.netWifiPasswordVerificationSuccess());
                                }
                                EntryClassUi.hideWaitModal();
                                ((this).this).TabWirelessUi.this.buttonPassword.setEnabled(true);
                            }
                        });
                    }
                });
            }
        });
        this.password.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                if (TabWirelessUi.this.groupVerify.isVisible() && !TabWirelessUi.this.verify.getText().equals(TabWirelessUi.this.password.getText())) {
                    TabWirelessUi.this.groupVerify.setValidationState(ValidationState.ERROR);
                } else {
                    TabWirelessUi.this.groupVerify.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.password.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabWirelessUi.this.refreshForm();
                TabWirelessUi.this.checkPassword();
            }
        });
        this.labelVerify.setText(MSGS.netWifiWirelessVerifyPassword());
        this.verify.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.verify.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipPassword()));
                }
            }
        });
        this.verify.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.verify.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (TabWirelessUi.this.password != null && !TabWirelessUi.this.verify.getText().equals(TabWirelessUi.this.password.getText())) {
                    TabWirelessUi.this.helpVerify.setText(MSGS.netWifiWirelessPasswordDoesNotMatch());
                    TabWirelessUi.this.groupVerify.setValidationState(ValidationState.ERROR);
                } else {
                    TabWirelessUi.this.helpVerify.setText("");
                    TabWirelessUi.this.groupVerify.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelPairwise.setText(MSGS.netWifiWirelessPairwiseCiphers());
        this.pairwise.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.pairwise.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipPairwiseCiphers()));
                }
            }
        });
        this.pairwise.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        enumArray = GwtWifiCiphers.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            ciphers = enumArray[n2];
            this.pairwise.addItem(MessageUtils.get(ciphers.name()));
            ++n2;
        }
        this.pairwise.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabWirelessUi.this.refreshForm();
            }
        });
        this.labelGroup.setText(MSGS.netWifiWirelessGroupCiphers());
        this.group.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.group.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiWirelessGroupCiphers()));
                }
            }
        });
        this.group.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        enumArray = GwtWifiCiphers.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            ciphers = enumArray[n2];
            this.group.addItem(MessageUtils.get(ciphers.name()));
            ++n2;
        }
        this.group.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabWirelessUi.this.refreshForm();
            }
        });
        this.labelBgscan.setText(MSGS.netWifiWirelessBgscanModule());
        this.bgscan.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.bgscan.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipBgScan()));
                }
            }
        });
        this.bgscan.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        enumArray = GwtWifiBgscanModule.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            Enum module = enumArray[n2];
            this.bgscan.addItem(MessageUtils.get(module.name()));
            ++n2;
        }
        this.bgscan.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                TabWirelessUi.this.refreshForm();
            }
        });
        this.labelRssi.setText(MSGS.netWifiWirelessBgscanSignalStrengthThreshold());
        this.labelShortI.setText(MSGS.netWifiWirelessBgscanShortInterval());
        this.shortI.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.shortI.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipBgScanShortInterval()));
                }
            }
        });
        this.shortI.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.shortI.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (TabWirelessUi.this.shortI.getText().trim().contains(".") || TabWirelessUi.this.shortI.getText().trim().contains("-") || !TabWirelessUi.this.shortI.getText().trim().matches("[0-9]+")) {
                    TabWirelessUi.this.groupShortI.setValidationState(ValidationState.ERROR);
                } else {
                    TabWirelessUi.this.groupShortI.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelLongI.setText(MSGS.netWifiWirelessBgscanLongInterval());
        this.longI.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.longI.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipBgScanLongInterval()));
                }
            }
        });
        this.longI.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.longI.addChangeHandler(new ChangeHandler(){

            public void onChange(ChangeEvent event) {
                if (TabWirelessUi.this.longI.getText().trim().contains(".") || TabWirelessUi.this.longI.getText().trim().contains("-") || !TabWirelessUi.this.longI.getText().trim().matches("[0-9]+")) {
                    TabWirelessUi.this.groupLongI.setValidationState(ValidationState.ERROR);
                } else {
                    TabWirelessUi.this.groupLongI.setValidationState(ValidationState.NONE);
                }
            }
        });
        this.labelPing.setText(MSGS.netWifiWirelessPingAccessPoint());
        this.radio1.setText(MSGS.trueLabel());
        this.radio1.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.radio1.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipPingAccessPoint()));
                }
            }
        });
        this.radio1.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.radio2.setText(MSGS.falseLabel());
        this.radio2.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.radio2.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipPingAccessPoint()));
                }
            }
        });
        this.radio2.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.labelIgnore.setText(MSGS.netWifiWirelessIgnoreSSID());
        this.radio3.setText(MSGS.trueLabel());
        this.radio3.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.radio3.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipIgnoreSSID()));
                }
            }
        });
        this.radio3.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.radio4.setText(MSGS.falseLabel());
        this.radio4.addMouseOverHandler(new MouseOverHandler(){

            public void onMouseOver(MouseOverEvent event) {
                if (TabWirelessUi.this.radio4.isEnabled()) {
                    TabWirelessUi.this.helpText.clear();
                    TabWirelessUi.this.helpText.add((Widget)new Span(MSGS.netWifiToolTipIgnoreSSID()));
                }
            }
        });
        this.radio4.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                TabWirelessUi.this.resetHelp();
            }
        });
        this.initGrid();
        this.helpTitle.setText(MSGS.netHelpTitle());
    }

    private void resetHelp() {
        this.helpText.clear();
        this.helpText.add((Widget)new Span(MSGS.netHelpDefaultHint()));
    }

    private void initGrid() {
        Column<GwtWifiChannelModel, Boolean> checkColumn = new Column<GwtWifiChannelModel, Boolean>((Cell)new CheckboxCell()){

            public Boolean getValue(GwtWifiChannelModel object) {
                return TabWirelessUi.this.channelGrid.getSelectionModel().isSelected((Object)object);
            }
        };
        checkColumn.setFieldUpdater((FieldUpdater)new FieldUpdater<GwtWifiChannelModel, Boolean>(){

            public void update(int index, GwtWifiChannelModel object, Boolean value) {
                TabWirelessUi.this.channelGrid.getSelectionModel().setSelected((Object)object, value.booleanValue());
                TabWirelessUi.this.channelDataProvider.refresh();
            }
        });
        checkColumn.setCellStyleNames("status-table-row");
        this.channelGrid.addColumn((Column)checkColumn);
        TextColumn<GwtWifiChannelModel> col1 = new TextColumn<GwtWifiChannelModel>(){

            public String getValue(GwtWifiChannelModel object) {
                return object.getName();
            }
        };
        col1.setCellStyleNames("status-table-row");
        this.channelGrid.addColumn((Column)col1, "All Available Channels");
        TextColumn<GwtWifiChannelModel> col2 = new TextColumn<GwtWifiChannelModel>(){

            public String getValue(GwtWifiChannelModel object) {
                return String.valueOf(object.getFrequency());
            }
        };
        col2.setCellStyleNames("status-table-row");
        this.channelGrid.addColumn((Column)col2, "Frequency (MHz)");
        TextColumn<GwtWifiChannelModel> col3 = new TextColumn<GwtWifiChannelModel>(){

            public String getValue(GwtWifiChannelModel object) {
                return String.valueOf(object.getBand());
            }
        };
        col3.setCellStyleNames("status-table-row");
        this.channelGrid.addColumn((Column)col3, "Frequency (MHz)");
        this.channelGrid.setSelectionModel(this.selectionModel);
        this.channelDataProvider.addDataDisplay(this.channelGrid);
        this.loadChannelData();
    }

    private void loadChannelData() {
        this.channelDataProvider.getList().clear();
        this.channelDataProvider.setList(GwtWifiChannelModel.getChannels());
        this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

            public void onFailure(Throwable ex) {
                FailureHandler.handle(ex);
            }

            public void onSuccess(GwtXSRFToken token) {
                TabWirelessUi.this.gwtDeviceService.findDeviceConfiguration(token, new AsyncCallback<ArrayList<GwtGroupedNVPair>>(){

                    public void onFailure(Throwable caught) {
                        (this).TabWirelessUi.this.channelGrid.setVisible(false);
                        FailureHandler.handle(caught);
                    }

                    public void onSuccess(ArrayList<GwtGroupedNVPair> result) {
                        if (result != null) {
                            (this).TabWirelessUi.this.channelGrid.setVisible(true);
                            for (GwtGroupedNVPair pair : result) {
                                int topChannel;
                                String name = pair.getName();
                                if (name == null || !name.equals("devLastWifiChannel") || (topChannel = Integer.parseInt(pair.getValue())) >= 13) continue;
                                try {
                                    TabWirelessUi.this.channelDataProvider.getList().remove(12);
                                    TabWirelessUi.this.channelDataProvider.getList().remove(11);
                                }
                                catch (IndexOutOfBoundsException | UnsupportedOperationException e) {
                                    logger.info(e.getLocalizedMessage());
                                }
                            }
                            TabWirelessUi.this.channelDataProvider.flush();
                        }
                    }
                });
            }
        });
        this.noChannelsText.setText(MSGS.netWifiAlertNoChannels());
        if (!this.channelDataProvider.getList().isEmpty()) {
            this.noChannels.setVisible(false);
            this.channelGrid.setVisible(true);
        } else {
            this.channelGrid.setVisible(false);
            this.noChannels.setVisible(true);
        }
    }

    private void setPasswordValidation() {
        if (this.security.getSelectedItemText().equals(WIFI_SECURITY_WPA_MESSAGE) || this.security.getSelectedItemText().equals(WIFI_SECURITY_WPA2_MESSAGE)) {
            this.passwordRegex = REGEX_PASSWORD_WPA;
            this.passwordError = MSGS.netWifiWirelessInvalidWPAPassword();
        } else if (this.security.getSelectedItemText().equals(WIFI_SECURITY_WEP_MESSAGE)) {
            this.passwordRegex = REGEX_PASSWORD_WEP;
            this.passwordError = MSGS.netWifiWirelessInvalidWEPPassword();
        } else {
            this.passwordRegex = REGEX_PASSWORD_ANY;
        }
        if (this.password.getText() != null && !this.password.getText().matches(this.passwordRegex)) {
            this.groupPassword.setValidationState(ValidationState.ERROR);
        } else {
            this.groupPassword.setValidationState(ValidationState.NONE);
        }
        if (this.password.getText() != null && this.groupVerify.isVisible() && this.verify.getText() != null && !this.password.getText().equals(this.verify.getText())) {
            this.groupVerify.setValidationState(ValidationState.ERROR);
        } else {
            this.groupVerify.setValidationState(ValidationState.NONE);
        }
    }

    private void initModal() {
        this.ssidModal.setTitle("Wireless Networks");
        this.ssidTitle.setText("Available networks in range");
        this.ssidModal.show();
        this.searchingText.setText(MSGS.netWifiAlertScanning());
        this.noSsidText.setText(MSGS.netWifiAlertNoSSID());
        this.scanFailText.setText(MSGS.netWifiAlertScanFail());
    }

    private void initSsid() {
        this.ssidInit = true;
        TextColumn<GwtWifiHotspotEntry> col1 = new TextColumn<GwtWifiHotspotEntry>(){

            public String getValue(GwtWifiHotspotEntry object) {
                return object.getSSID();
            }
        };
        col1.setCellStyleNames("status-table-row");
        this.ssidGrid.addColumn((Column)col1, "SSID");
        this.ssidGrid.setColumnWidth((Column)col1, "240px");
        TextColumn<GwtWifiHotspotEntry> col2 = new TextColumn<GwtWifiHotspotEntry>(){

            public String getValue(GwtWifiHotspotEntry object) {
                return object.getMacAddress();
            }
        };
        col2.setCellStyleNames("status-table-row");
        this.ssidGrid.addColumn((Column)col2, "MAC Address");
        this.ssidGrid.setColumnWidth((Column)col2, "140px");
        TextColumn<GwtWifiHotspotEntry> col3 = new TextColumn<GwtWifiHotspotEntry>(){

            public String getValue(GwtWifiHotspotEntry object) {
                return String.valueOf(object.getSignalStrength());
            }
        };
        col3.setCellStyleNames("status-table-row");
        this.ssidGrid.addColumn((Column)col3, "Signal Strength (dBm)");
        this.ssidGrid.setColumnWidth((Column)col3, "70px");
        TextColumn<GwtWifiHotspotEntry> col4 = new TextColumn<GwtWifiHotspotEntry>(){

            public String getValue(GwtWifiHotspotEntry object) {
                return String.valueOf(object.getChannel());
            }
        };
        col4.setCellStyleNames("status-table-row");
        this.ssidGrid.addColumn((Column)col4, "Channel");
        this.ssidGrid.setColumnWidth((Column)col4, "70px");
        TextColumn<GwtWifiHotspotEntry> col5 = new TextColumn<GwtWifiHotspotEntry>(){

            public String getValue(GwtWifiHotspotEntry object) {
                return String.valueOf(object.getFrequency());
            }
        };
        col5.setCellStyleNames("status-table-row");
        this.ssidGrid.addColumn((Column)col5, "Frequency");
        this.ssidGrid.setColumnWidth((Column)col5, "70px");
        TextColumn<GwtWifiHotspotEntry> col6 = new TextColumn<GwtWifiHotspotEntry>(){

            public String getValue(GwtWifiHotspotEntry object) {
                return object.getSecurity();
            }
        };
        col6.setCellStyleNames("status-table-row");
        this.ssidGrid.addColumn((Column)col6, "Security");
        this.ssidGrid.setColumnWidth((Column)col6, "70px");
        this.ssidDataProvider.addDataDisplay(this.ssidGrid);
        this.ssidGrid.setSelectionModel(this.ssidSelectionModel);
        this.ssidSelectionModel.addSelectionChangeHandler(new SelectionChangeEvent.Handler(){

            public void onSelectionChange(SelectionChangeEvent event) {
                GwtWifiHotspotEntry wifiHotspotEntry = (GwtWifiHotspotEntry)TabWirelessUi.this.ssidSelectionModel.getSelectedObject();
                if (wifiHotspotEntry != null) {
                    TabWirelessUi.this.ssid.setValue((Object)wifiHotspotEntry.getSSID());
                    String sec = wifiHotspotEntry.getSecurity();
                    int i = 0;
                    while (i < TabWirelessUi.this.security.getItemCount()) {
                        if (sec.equals(TabWirelessUi.this.security.getItemText(i))) {
                            TabWirelessUi.this.security.setSelectedIndex(i);
                            DomEvent.fireNativeEvent((NativeEvent)Document.get().createChangeEvent(), (HasHandlers)TabWirelessUi.this.security);
                            break;
                        }
                        ++i;
                    }
                    String pairwiseCiphers = wifiHotspotEntry.getPairwiseCiphersEnum().name();
                    int i2 = 0;
                    while (i2 < TabWirelessUi.this.pairwise.getItemCount()) {
                        if (MessageUtils.get(pairwiseCiphers).equals(TabWirelessUi.this.pairwise.getItemText(i2))) {
                            TabWirelessUi.this.pairwise.setSelectedIndex(i2);
                            break;
                        }
                        ++i2;
                    }
                    String groupCiphers = wifiHotspotEntry.getGroupCiphersEnum().name();
                    int i3 = 0;
                    while (i3 < TabWirelessUi.this.group.getItemCount()) {
                        if (MessageUtils.get(groupCiphers).equals(TabWirelessUi.this.group.getItemText(i3))) {
                            TabWirelessUi.this.group.setSelectedIndex(i3);
                            break;
                        }
                        ++i3;
                    }
                    int channelListSize = TabWirelessUi.this.channelDataProvider.getList().size();
                    int maxIndex = Math.min(channelListSize, 13);
                    int channel = 1;
                    while (channel <= maxIndex) {
                        TabWirelessUi.this.selectionModel.setSelected((Object)((GwtWifiChannelModel)TabWirelessUi.this.channelDataProvider.getList().get(channel - 1)), false);
                        ++channel;
                    }
                    TabWirelessUi.this.selectionModel.setSelected((Object)((GwtWifiChannelModel)TabWirelessUi.this.channelDataProvider.getList().get(wifiHotspotEntry.getChannel() - 1)), true);
                    TabWirelessUi.this.ssidModal.hide();
                }
            }
        });
    }

    private void loadSsidData() {
        this.ssidDataProvider.getList().clear();
        this.searching.setVisible(true);
        this.noSsid.setVisible(false);
        this.ssidGrid.setVisible(false);
        this.scanFail.setVisible(false);
        if (this.selectedNetIfConfig != null) {
            this.gwtXSRFService.generateSecurityToken(new AsyncCallback<GwtXSRFToken>(){

                public void onFailure(Throwable ex) {
                    FailureHandler.handle(ex);
                }

                public void onSuccess(GwtXSRFToken token) {
                    TabWirelessUi.this.gwtNetworkService.findWifiHotspots(token, TabWirelessUi.this.selectedNetIfConfig.getName(), TabWirelessUi.this.selectedNetIfConfig.getAccessPointWifiConfig().getWirelessSsid(), new AsyncCallback<List<GwtWifiHotspotEntry>>(){

                        public void onFailure(Throwable caught) {
                            (this).TabWirelessUi.this.searching.setVisible(false);
                            (this).TabWirelessUi.this.noSsid.setVisible(false);
                            (this).TabWirelessUi.this.ssidGrid.setVisible(false);
                            (this).TabWirelessUi.this.scanFail.setVisible(true);
                        }

                        public void onSuccess(List<GwtWifiHotspotEntry> result) {
                            for (GwtWifiHotspotEntry pair : result) {
                                TabWirelessUi.this.ssidDataProvider.getList().add(pair);
                            }
                            TabWirelessUi.this.ssidDataProvider.flush();
                            if (!TabWirelessUi.this.ssidDataProvider.getList().isEmpty()) {
                                (this).TabWirelessUi.this.searching.setVisible(false);
                                (this).TabWirelessUi.this.noSsid.setVisible(false);
                                int size = TabWirelessUi.this.ssidDataProvider.getList().size();
                                (this).TabWirelessUi.this.ssidGrid.setVisibleRange(0, size);
                                (this).TabWirelessUi.this.ssidGrid.setVisible(true);
                                (this).TabWirelessUi.this.scanFail.setVisible(false);
                            } else {
                                (this).TabWirelessUi.this.searching.setVisible(false);
                                (this).TabWirelessUi.this.noSsid.setVisible(true);
                                (this).TabWirelessUi.this.ssidGrid.setVisible(false);
                                (this).TabWirelessUi.this.scanFail.setVisible(false);
                            }
                        }
                    });
                }
            });
        }
    }

    private GwtWifiConfig getGwtWifiConfig() {
        GwtWifiConfig gwtWifiConfig = new GwtWifiConfig();
        GwtWifiWirelessMode wifiMode = this.wireless.getSelectedItemText().equals(MessageUtils.get(WIFI_MODE_STATION)) ? GwtWifiWirelessMode.netWifiWirelessModeStation : GwtWifiWirelessMode.netWifiWirelessModeAccessPoint;
        gwtWifiConfig.setWirelessMode(wifiMode.name());
        gwtWifiConfig.setWirelessSsid(GwtSafeHtmlUtils.htmlUnescape(this.ssid.getText().trim()));
        String driver = "";
        if (GwtWifiWirelessMode.netWifiWirelessModeAccessPoint.equals((Object)wifiMode)) {
            driver = this.selectedNetIfConfig.getAccessPointWifiConfig().getDriver();
        } else if (GwtWifiWirelessMode.netWifiWirelessModeAdHoc.equals((Object)wifiMode)) {
            driver = this.selectedNetIfConfig.getAdhocWifiConfig().getDriver();
        } else if (GwtWifiWirelessMode.netWifiWirelessModeStation.equals((Object)wifiMode)) {
            driver = this.selectedNetIfConfig.getStationWifiConfig().getDriver();
        }
        gwtWifiConfig.setDriver(driver);
        String radioValue = this.radio.getSelectedItemText();
        GwtWifiRadioMode[] gwtWifiRadioModeArray = GwtWifiRadioMode.values();
        int n = gwtWifiRadioModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            GwtWifiRadioMode mode = gwtWifiRadioModeArray[n2];
            if (MessageUtils.get(mode.name()).equals(radioValue)) {
                gwtWifiConfig.setRadioMode(mode.name());
            }
            ++n2;
        }
        Set lSelectedChannels = this.selectionModel.getSelectedSet();
        ArrayList<Integer> alChannels = new ArrayList<Integer>();
        for (GwtWifiChannelModel item : lSelectedChannels) {
            alChannels.add(item.getChannel());
        }
        if (alChannels.isEmpty()) {
            alChannels.add(1);
        }
        gwtWifiConfig.setChannels(alChannels);
        String secValue = this.security.getSelectedItemText();
        GwtWifiSecurity[] gwtWifiSecurityArray = GwtWifiSecurity.values();
        int n3 = gwtWifiSecurityArray.length;
        int n4 = 0;
        while (n4 < n3) {
            GwtWifiSecurity sec = gwtWifiSecurityArray[n4];
            if (MessageUtils.get(sec.name()).equals(secValue)) {
                gwtWifiConfig.setSecurity(sec.name());
            }
            ++n4;
        }
        String pairWiseCiphersValue = this.pairwise.getSelectedItemText();
        GwtWifiCiphers[] gwtWifiCiphersArray = GwtWifiCiphers.values();
        int n5 = gwtWifiCiphersArray.length;
        n3 = 0;
        while (n3 < n5) {
            GwtWifiCiphers ciphers = gwtWifiCiphersArray[n3];
            if (MessageUtils.get(ciphers.name()).equals(pairWiseCiphersValue)) {
                gwtWifiConfig.setPairwiseCiphers(ciphers.name());
            }
            ++n3;
        }
        String groupCiphersValue = this.group.getSelectedItemText();
        GwtWifiCiphers[] gwtWifiCiphersArray2 = GwtWifiCiphers.values();
        int n6 = gwtWifiCiphersArray2.length;
        n5 = 0;
        while (n5 < n6) {
            GwtWifiCiphers ciphers = gwtWifiCiphersArray2[n5];
            if (MessageUtils.get(ciphers.name()).equals(groupCiphersValue)) {
                gwtWifiConfig.setGroupCiphers(ciphers.name());
            }
            ++n5;
        }
        String bgscanModuleValue = this.bgscan.getSelectedItemText();
        GwtWifiBgscanModule[] gwtWifiBgscanModuleArray = GwtWifiBgscanModule.values();
        int n7 = gwtWifiBgscanModuleArray.length;
        n6 = 0;
        while (n6 < n7) {
            GwtWifiBgscanModule module = gwtWifiBgscanModuleArray[n6];
            if (MessageUtils.get(module.name()).equals(bgscanModuleValue)) {
                gwtWifiConfig.setBgscanModule(module.name());
            }
            ++n6;
        }
        gwtWifiConfig.setBgscanShortInterval(Integer.parseInt(this.shortI.getText()));
        gwtWifiConfig.setBgscanLongInterval(Integer.parseInt(this.longI.getText()));
        if (this.groupPassword.getValidationState().equals((Object)ValidationState.NONE)) {
            gwtWifiConfig.setPassword(this.password.getText());
        }
        gwtWifiConfig.setPingAccessPoint(this.radio1.getValue());
        gwtWifiConfig.setIgnoreSSID(this.radio3.getValue());
        return gwtWifiConfig;
    }

    private void setForm(boolean b) {
        this.channelGrid.setVisible(b);
        this.wireless.setEnabled(b);
        this.ssid.setEnabled(b);
        this.buttonSsid.setEnabled(b);
        this.radio.setEnabled(b);
        this.security.setEnabled(b);
        this.password.setEnabled(b);
        this.buttonPassword.setEnabled(b);
        this.verify.setEnabled(b);
        this.pairwise.setEnabled(b);
        this.group.setEnabled(b);
        this.bgscan.setEnabled(b);
        this.shortI.setEnabled(b);
        this.longI.setEnabled(b);
        this.radio1.setEnabled(b);
        this.radio2.setEnabled(b);
        this.radio3.setEnabled(b);
        this.radio4.setEnabled(b);
        this.groupVerify.setVisible(b);
    }

    private void checkPassword() {
        if (!this.password.getText().matches(this.passwordRegex)) {
            this.groupPassword.setValidationState(ValidationState.ERROR);
            this.helpPassword.setText(this.passwordError);
        } else {
            this.groupPassword.setValidationState(ValidationState.NONE);
            this.helpPassword.setText("");
        }
    }

    private void showPasswordVerificationStatus(String statusMessage) {
        final Modal confirm = new Modal();
        ModalBody confirmBody = new ModalBody();
        ModalFooter confirmFooter = new ModalFooter();
        confirm.setTitle(MSGS.netWifiPasswordVerificationStatus());
        confirmBody.add((Widget)new Span(statusMessage));
        confirmFooter.add((Widget)new Button(MSGS.closeButton(), new ClickHandler(){

            public void onClick(ClickEvent event) {
                confirm.hide();
            }
        }));
        confirm.add((Widget)confirmBody);
        confirm.add((Widget)confirmFooter);
        confirm.show();
    }

    static interface TabWirelessUiUiBinder
    extends UiBinder<Widget, TabWirelessUi> {
    }
}

