/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.kura.web.client.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.ui.Widget;
import org.eclipse.kura.web.client.messages.Messages;
import org.eclipse.kura.web.client.ui.EntryClassUi;
import org.eclipse.kura.web.shared.model.GwtConfigComponent;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.ModalHeader;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.client.ui.html.Span;

public class ServicesAnchorListItem
extends AnchorListItem {
    private static final String SERVLET_URL = "/" + GWT.getModuleName() + "/file/icon?";
    EntryClassUi ui;
    GwtConfigComponent item;
    ServicesAnchorListItem instance;
    private static final Messages MSGS = (Messages)GWT.create(Messages.class);

    public ServicesAnchorListItem(GwtConfigComponent service, EntryClassUi mainUi) {
        this.ui = mainUi;
        this.item = service;
        this.instance = this;
        IconType icon = this.getIcon(this.item);
        if (icon == null) {
            String imageURL = this.getImagePath();
            if (imageURL != null) {
                StringBuilder imageTag = new StringBuilder();
                imageTag.append("<img src='");
                imageTag.append(imageURL);
                imageTag.append("' height='14' width='14'/>");
                imageTag.append(" ");
                imageTag.append(this.item.getComponentName());
                this.anchor.setHTML(imageTag.toString());
            } else {
                super.setIcon(IconType.CHEVRON_CIRCLE_RIGHT);
                super.setText(this.item.getComponentName());
            }
        } else {
            super.setIcon(icon);
            super.setText(this.item.getComponentName());
        }
        String description = service.getComponentDescription();
        if (description != null && !description.isEmpty()) {
            super.setTitle(description);
        }
        super.addClickHandler(event -> {
            if (this.ui.getSelected() != null && this.ui.getSelected() != this.item && this.ui.isServicesUiDirty() || this.ui.isNetworkDirty() || this.ui.isFirewallDirty() || this.ui.isSettingsDirty()) {
                Modal modal = new Modal();
                ModalHeader header = new ModalHeader();
                header.setTitle(MSGS.warning());
                modal.add((Widget)header);
                ModalBody body = new ModalBody();
                body.add((Widget)new Span(MSGS.deviceConfigDirty()));
                modal.add((Widget)body);
                ModalFooter footer = new ModalFooter();
                Button yes = new Button(MSGS.yesButton(), event11 -> {
                    this.ui.setDirty();
                    this.ui.setSelected(this.item);
                    modal.hide();
                    this.ui.render(this.item);
                });
                Button no = new Button(MSGS.noButton(), event12 -> modal.hide());
                footer.add((Widget)no);
                footer.add((Widget)yes);
                modal.add((Widget)footer);
                modal.show();
                no.setFocus(true);
            } else {
                this.ui.setSelected(this.item);
                this.ui.setSelectedAnchorListItem(this);
                this.ui.render(this.item);
            }
        });
    }

    public String getServiceName() {
        return this.item.getComponentName();
    }

    private IconType getIcon(GwtConfigComponent item) {
        String name = item.getComponentName();
        if (name.startsWith("BluetoothService")) {
            return IconType.BTC;
        }
        if (name.startsWith("BrokerInstance")) {
            return IconType.RSS;
        }
        if (name.startsWith("CloudService")) {
            return IconType.CLOUD;
        }
        if (name.startsWith("DiagnosticsService")) {
            return IconType.AMBULANCE;
        }
        if (name.startsWith("ClockService")) {
            return IconType.CLOCK_O;
        }
        if (name.startsWith("DataService")) {
            return IconType.DATABASE;
        }
        if (name.startsWith("MqttDataTransport")) {
            return IconType.FORUMBEE;
        }
        if (name.startsWith("PositionService")) {
            return IconType.LOCATION_ARROW;
        }
        if (name.startsWith("WatchdogService")) {
            return IconType.HEARTBEAT;
        }
        if (name.startsWith("SslManagerService")) {
            return IconType.LOCK;
        }
        if (name.startsWith("VpnService")) {
            return IconType.CONNECTDEVELOP;
        }
        if (name.startsWith("ProvisioningService")) {
            return IconType.CLOUD_DOWNLOAD;
        }
        if (name.startsWith("CommandPasswordService")) {
            return IconType.CHAIN;
        }
        if (name.startsWith("WebConsole")) {
            return IconType.LAPTOP;
        }
        if (name.startsWith("CommandService")) {
            return IconType.TERMINAL;
        }
        if (name.startsWith("DenaliService")) {
            return IconType.SPINNER;
        }
        if (name.contains("H2Db")) {
            return IconType.DATABASE;
        }
        if (name.startsWith("DeploymentService")) {
            return IconType.DOWNLOAD;
        }
        if (name.startsWith("RebootService")) {
            return IconType.REFRESH;
        }
        if (name.startsWith("VpnClient")) {
            return IconType.ARROWS_H;
        }
        if (name.startsWith("TerminalClientService")) {
            return IconType.RANDOM;
        }
        if (name.startsWith("TerminalServerService")) {
            return IconType.RANDOM;
        }
        String id = item.getComponentId();
        if (id.endsWith(".BrokerInstance")) {
            return IconType.RSS;
        }
        return null;
    }

    private String getImagePath() {
        String icon = this.item.getComponentIcon();
        if (icon == null) {
            return null;
        }
        if (!this.isImagePath(icon)) {
            return null;
        }
        if (icon.toLowerCase().startsWith("http://") || icon.toLowerCase().startsWith("https://")) {
            return icon;
        }
        String factoryId = this.item.getFactoryId();
        if (factoryId != null) {
            return String.valueOf(SERVLET_URL) + "factoryId=" + URL.encodeQueryString((String)factoryId);
        }
        String componentId = this.item.getComponentId();
        if (componentId != null) {
            return String.valueOf(SERVLET_URL) + "pid=" + URL.encodeQueryString((String)componentId);
        }
        return null;
    }

    private boolean isImagePath(String icon) {
        boolean isPng = icon.toLowerCase().endsWith(".png");
        boolean isJpg = icon.toLowerCase().endsWith(".jpg");
        boolean isGif = icon.toLowerCase().endsWith(".gif");
        return isPng || isJpg || isGif;
    }
}

