/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.localfolder;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.localfolder.LocalFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileBasedLocation
implements IVcsManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalFolder.class);
    protected static final String FIRST_REV = "0";
    protected IConsole console;
    protected String repositoryURL;
    private boolean isFrozen = false;

    public String getLocation() {
        return this.repositoryURL;
    }

    public void setCredentials(String username, String password, ICredentialsStore credStore) {
    }

    protected String makeRelative(String base, String extension) {
        if (!extension.startsWith(base)) {
            return extension;
        }
        return extension.substring(base.length());
    }

    public boolean isAuthSupported() {
        return false;
    }

    public boolean isPathLocationAccepted() {
        return true;
    }

    public boolean isURLLocationAccepted() {
        return true;
    }

    public String getRepositoryPath(String rawPath) {
        String emfUriPrefix = this.getLocation().replaceFirst("file:///", "file:/");
        if (rawPath.startsWith(emfUriPrefix)) {
            return rawPath.substring(emfUriPrefix.length());
        }
        return rawPath;
    }

    public String getUsername() {
        return null;
    }

    public String getPassword() {
        return null;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean f) {
        this.isFrozen = f;
    }

    public String getFirstRevision() throws Exception {
        return FIRST_REV;
    }

    public String getCurrentRevision() {
        return this.getCurrentRevision(false);
    }

    protected abstract String getCurrentRevision(boolean var1);

    public void run() {
    }

    public List<VcsCommitItem> getDelta(String startRevision) throws Exception {
        return this.getDelta(startRevision, "HEAD").getCompactedCommitItems();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected byte[] digestFile(File f) throws IOException {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                FileInputStream is = new FileInputStream(f);
                try {
                    try (DigestInputStream dis = new DigestInputStream(is, md);){
                        IOUtils.copy((InputStream)dis, (OutputStream)bos);
                    }
                    if (is == null) return md.digest();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return md.digest();
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return new byte[0];
        }
    }
}

