/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.epsilon.emc.contextful;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.epsilon.emc.EOLQueryEngine;
import org.eclipse.hawk.epsilon.emc.contextful.AllOf;

public class TypeFirstAllOf
implements AllOf {
    private Function<IGraphNode, Iterable<? extends IGraphNode>> allFiles;
    private EOLQueryEngine engine;

    public TypeFirstAllOf(Function<IGraphNode, Iterable<? extends IGraphNode>> allFiles, EOLQueryEngine engine) {
        this.allFiles = allFiles;
        this.engine = engine;
    }

    @Override
    public void addAllOf(IGraphNode typeNode, String typeorkind, Collection<Object> nodes) {
        HashSet<IGraphNode> files = new HashSet<IGraphNode>();
        for (IGraphNode iGraphNode : this.allFiles.apply(typeNode)) {
            files.add(iGraphNode);
        }
        for (IGraphEdge iGraphEdge : typeNode.getIncomingWithType(typeorkind)) {
            IGraphNode node = iGraphEdge.getStartNode();
            for (IGraphEdge e : node.getOutgoingWithType("_hawkFile")) {
                if (!files.contains(e.getEndNode())) continue;
                nodes.add(this.engine.wrap(node));
            }
        }
    }
}

