/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.metamodel;

import org.eclipse.hawk.core.model.IHawkAttribute;
import org.eclipse.hawk.core.model.IHawkClassifier;
import org.eclipse.hawk.core.model.IHawkReference;
import org.eclipse.hawk.core.model.IHawkStructuralFeature;
import org.eclipse.hawk.modelio.exml.metamodel.AbstractModelioObject;
import org.eclipse.hawk.modelio.exml.metamodel.ModelioClass;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MClass;
import org.eclipse.hawk.modelio.exml.metamodel.mlib.MDependency;

public class ModelioReference
extends AbstractModelioObject
implements IHawkReference {
    private final ModelioClass mClass;
    private final MDependency mDependency;

    public ModelioReference(ModelioClass mc, MDependency mdep) {
        this.mClass = mc;
        this.mDependency = mdep;
    }

    public MDependency getRawDependency() {
        return this.mDependency;
    }

    public String getName() {
        return this.mDependency.getName();
    }

    public boolean isMany() {
        return this.mDependency.isMany();
    }

    public boolean isUnique() {
        return this.mDependency.isUnique();
    }

    public boolean isOrdered() {
        return this.mDependency.isOrdered();
    }

    public boolean isRoot() {
        return false;
    }

    public String getUri() {
        return String.valueOf(this.mClass.getPackageNSURI()) + "#" + this.getUriFragment();
    }

    public String getUriFragment() {
        return this.mDependency.getId();
    }

    public boolean isFragmentUnique() {
        return true;
    }

    public boolean isSet(IHawkStructuralFeature hsf) {
        switch (hsf.getName()) {
            case "name": {
                return true;
            }
        }
        return false;
    }

    public Object get(IHawkAttribute attr) {
        switch (attr.getName()) {
            case "name": {
                return this.mDependency.getName();
            }
        }
        return null;
    }

    public Object get(IHawkReference ref, boolean b) {
        return null;
    }

    public boolean isContainment() {
        return this.mDependency.isComposition();
    }

    public boolean isContainer() {
        return false;
    }

    public IHawkClassifier getType() {
        MClass mDepClass = this.mDependency.getMClass();
        return this.mClass.getPackage().getResource().getModelioClassById(mDepClass.getId());
    }

    @Override
    public String getExml() {
        return null;
    }

    public String toString() {
        return "ModelioReference [getName()=" + this.getName() + ", isMany()=" + this.isMany() + ", isUnique()=" + this.isUnique() + ", isOrdered()=" + this.isOrdered() + ", isContainment()=" + this.isContainment() + ", getType()=" + this.getType() + "]";
    }
}

