/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.editors.text;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class TextOperationActionHandler
extends AbstractHandler {
    protected final int operationCode;

    public TextOperationActionHandler(int operationCode) {
        this.operationCode = operationCode;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        if (this.operationCode < 0) {
            return null;
        }
        IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
        ITextOperationTarget target = (ITextOperationTarget)part.getAdapter(ITextOperationTarget.class);
        if (target == null) {
            return null;
        }
        IWorkbenchPartSite site = part.getSite();
        Shell shell = site.getShell();
        if (shell != null && !shell.isDisposed()) {
            Display display = shell.getDisplay();
            BusyIndicator.showWhile((Display)display, () -> target.doOperation(this.operationCode));
            return Status.OK_STATUS;
        }
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            this.setBaseEnabled(false);
            return;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            this.setBaseEnabled(false);
            return;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            this.setBaseEnabled(false);
            return;
        }
        IWorkbenchPart part = page.getActivePart();
        this.setBaseEnabled(part != null && part.getAdapter(ITextOperationTarget.class) != null);
    }
}

