/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.orientdb;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.orientdb.OrientDatabase;
import org.eclipse.hawk.orientdb.OrientLightEdge;
import org.eclipse.hawk.orientdb.OrientNode;

public class OrientEdge
implements IGraphEdge {
    private static final String TYPE_PROPERTY = "_hp_type";
    private static final String FROM_PROPERTY = "out";
    private static final String TO_PROPERTY = "in";
    private static final String FROM_PROPERTY_OLD = "_hp_from";
    private static final String TO_PROPERTY_OLD = "_hp_to";
    private final OrientDatabase db;
    private ORID id;
    private ODocument changedEdge;

    public OrientEdge(ORID id, OrientDatabase graph) {
        this.id = id;
        this.db = graph;
    }

    public OrientEdge(ODocument newDoc, OrientDatabase graph) {
        this.db = graph;
        this.changedEdge = newDoc;
        this.id = this.changedEdge.getIdentity();
    }

    public ORID getId() {
        if (this.changedEdge != null) {
            return this.changedEdge.getIdentity();
        }
        return this.id;
    }

    public String getType() {
        ODocument tmpEdge = this.getDocument();
        return tmpEdge.field(TYPE_PROPERTY).toString();
    }

    public Set<String> getPropertyKeys() {
        ODocument tmpEdge = this.getDocument();
        HashSet<String> fieldNames = new HashSet<String>(Arrays.asList(tmpEdge.fieldNames()));
        fieldNames.remove(TYPE_PROPERTY);
        fieldNames.remove(FROM_PROPERTY);
        fieldNames.remove(TO_PROPERTY);
        fieldNames.remove(FROM_PROPERTY_OLD);
        fieldNames.remove(TO_PROPERTY_OLD);
        return fieldNames;
    }

    public Object getProperty(String name) {
        ODocument tmpEdge = this.getDocument();
        return tmpEdge.field(name);
    }

    public void setProperty(String name, Object value) {
        this.changedEdge = this.getDocument();
        this.changedEdge.field(name, value);
        this.db.markEdgeAsDirty(this);
    }

    public OrientNode getStartNode() {
        OrientNode fromNode = this.getNode(FROM_PROPERTY);
        return fromNode != null ? fromNode : this.getNode(FROM_PROPERTY_OLD);
    }

    public OrientNode getEndNode() {
        OrientNode toNode = this.getNode(TO_PROPERTY);
        return toNode != null ? toNode : this.getNode(TO_PROPERTY_OLD);
    }

    private OrientNode getNode(String property) {
        ODocument tmpEdge = this.getDocument();
        tmpEdge.setTrackingChanges(false);
        Object value = tmpEdge.field(property);
        tmpEdge.setTrackingChanges(true);
        if (value instanceof ODocument) {
            ODocument doc = (ODocument)value;
            return this.db.getNodeById(doc);
        }
        if (value != null) {
            ORecordId id = (ORecordId)value;
            return this.db.getNodeById(id);
        }
        return null;
    }

    public void delete() {
        OrientNode startNode = this.getStartNode();
        OrientNode endNode = this.getEndNode();
        ODocument doc = this.getDocument();
        String edgeType = (String)doc.field(TYPE_PROPERTY);
        startNode.removeOutgoing(doc, edgeType);
        endNode.removeIncoming(doc, edgeType);
        this.db.markNodeAsDirty(startNode);
        this.db.markNodeAsDirty(endNode);
        this.db.unmarkEdgeAsDirty(this);
        this.db.getGraph().delete(this.getId());
        this.changedEdge = null;
    }

    public void removeProperty(String name) {
        this.changedEdge = this.getDocument();
        this.changedEdge.removeField(name);
        this.db.markEdgeAsDirty(this);
    }

    public int hashCode() {
        int prime = 5381;
        int result = 1;
        result = 5381 * result + (this.getId() == null ? 0 : this.getId().toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OrientEdge other = (OrientEdge)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals((Object)other.getId()));
    }

    public String toString() {
        return "OrientEdge [" + this.getId() + "]";
    }

    public ODocument getDocument() {
        if (this.changedEdge != null) {
            return this.changedEdge;
        }
        ODocument dirtyEdge = this.db.getEdgeById((Object)this.getId()).changedEdge;
        if (dirtyEdge != null) {
            return dirtyEdge;
        }
        return (ODocument)this.db.getGraph().load(this.getId());
    }

    public static IGraphEdge create(OrientDatabase graph, OrientNode start, OrientNode end, String type, String edgeTypeName, Map<String, Object> props) {
        if (props != null && !props.isEmpty()) {
            ODocument newDoc = new ODocument(edgeTypeName);
            newDoc.field(TYPE_PROPERTY, (Object)type);
            ODocument startDoc = start.getDocument();
            ORID startId = startDoc.getIdentity();
            if (startId.isPersistent()) {
                newDoc.field(FROM_PROPERTY, (Object)startId);
            } else {
                newDoc.field(FROM_PROPERTY, (Object)startDoc);
            }
            ODocument endDoc = end.getDocument();
            ORID endId = endDoc.getIdentity();
            if (endId.isPersistent()) {
                newDoc.field(TO_PROPERTY, (Object)endId);
            } else {
                newDoc.field(TO_PROPERTY, (Object)endDoc);
            }
            if (props != null) {
                for (Map.Entry<String, Object> entry : props.entrySet()) {
                    newDoc.field(entry.getKey(), entry.getValue());
                }
            }
            newDoc.save(edgeTypeName);
            OrientEdge newEdge = newDoc.getIdentity().isPersistent() ? new OrientEdge(newDoc.getIdentity(), graph) : new OrientEdge(newDoc, graph);
            start.addOutgoing(newDoc, type);
            end.addIncoming(newDoc, type);
            return newEdge;
        }
        start.addOutgoing(end.getDocument(), type);
        end.addIncoming(start.getDocument(), type);
        return new OrientLightEdge(start, end, type);
    }

    public void save() {
        if (this.changedEdge != null && this.changedEdge.isDirty()) {
            this.changedEdge.save();
            this.changedEdge = null;
            this.changedEdge = this.getDocument();
        }
        if (this.getId().isPersistent()) {
            this.changedEdge = null;
        }
    }

    protected static void setupDocumentClass(OClass docClass) {
        docClass.createProperty(FROM_PROPERTY, OType.LINK);
        docClass.createProperty(TO_PROPERTY, OType.LINK);
        docClass.createProperty(TYPE_PROPERTY, OType.STRING);
    }
}

