/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.model;

import junit.framework.TestCase;
import org.eclipse.handly.model.ElementDeltas;
import org.eclipse.handly.model.IElement;
import org.eclipse.handly.model.IElementDelta;
import org.eclipse.handly.model.impl.support.ElementDelta;
import org.eclipse.handly.model.impl.support.SimpleElement;
import org.eclipse.handly.model.impl.support.SimpleModelManager;

public class ElementDeltasTest
extends TestCase {
    private SimpleElement root;
    private ElementDelta delta;
    private ElementDelta.Builder builder;

    protected void setUp() throws Exception {
        super.setUp();
        this.root = new SimpleElement(null, "root", new SimpleModelManager());
        this.delta = new ElementDelta((IElement)this.root);
        this.builder = new ElementDelta.Builder(this.delta);
    }

    public void test01() {
        ElementDeltasTest.assertFalse((boolean)ElementDeltas.isStructuralChange((IElementDelta)this.delta));
    }

    public void test02() {
        this.builder.added((IElement)this.root);
        ElementDeltasTest.assertTrue((boolean)ElementDeltas.isStructuralChange((IElementDelta)this.delta));
    }

    public void test03() {
        this.builder.removed((IElement)this.root);
        ElementDeltasTest.assertTrue((boolean)ElementDeltas.isStructuralChange((IElementDelta)this.delta));
    }

    public void test04() {
        this.builder.changed((IElement)this.root, 2L);
        ElementDeltasTest.assertTrue((boolean)ElementDeltas.isStructuralChange((IElementDelta)this.delta));
    }

    public void test05() {
        this.builder.changed((IElement)this.root, 1L);
        ElementDeltasTest.assertTrue((boolean)ElementDeltas.isStructuralChange((IElementDelta)this.delta));
    }

    public void test06() {
        this.builder.changed((IElement)this.root, 33L);
        ElementDeltasTest.assertFalse((boolean)ElementDeltas.isStructuralChange((IElementDelta)this.delta));
    }

    public void test07() {
        this.builder.changed((IElement)this.root, 0x7FFFFFFFFFFFFFFCL);
        ElementDeltasTest.assertFalse((boolean)ElementDeltas.isStructuralChange((IElementDelta)this.delta));
    }

    public void test08() {
        ElementDeltasTest.assertTrue((boolean)ElementDeltas.isNullOrEmpty(null));
        ElementDeltasTest.assertTrue((boolean)ElementDeltas.isNullOrEmpty((IElementDelta)this.delta));
        this.builder.added((IElement)this.root);
        ElementDeltasTest.assertFalse((boolean)ElementDeltas.isNullOrEmpty((IElementDelta)this.delta));
    }
}

