/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.java;

import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.IDiagnostician;
import org.eclipse.etrice.generator.base.AbstractGenerator;
import org.eclipse.etrice.generator.base.IDataConfiguration;
import org.eclipse.etrice.generator.base.args.Arguments;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.base.logging.Loglevel;
import org.eclipse.etrice.generator.java.gen.MainGen;
import org.eclipse.etrice.generator.java.gen.Validator;
import org.eclipse.etrice.generator.java.setup.GeneratorModule;

@Singleton
public class Main
extends AbstractGenerator {
    @Inject
    private MainGen mainGenerator;
    @Inject
    private Validator validator;
    @Inject
    protected IDataConfiguration dataConfig;

    public static int run(String[] args) {
        return Main.createAndRunGenerator((Module)new GeneratorModule(), (String[])args);
    }

    public static void main(String[] args) {
        int ret = Main.run(args);
        System.exit(ret);
    }

    protected int runGenerator(List<Resource> resources, Arguments arguments, IGeneratorFileIO fileIO, ILogger logger) {
        if (!this.dataConfig.setResources(this.getResourceSet(), logger)) {
            logger.logError("configuration errors");
            return 1;
        }
        Root genModel = this.createGeneratorModel(resources, arguments, fileIO, logger);
        if (this.diagnostician.isFailed() || genModel == null) {
            logger.logError("errors during build of generator model");
            return 1;
        }
        if (!this.validator.validate(genModel)) {
            logger.logError("validation failed during build of generator model");
            return 1;
        }
        ETMapUtil.processModels((Root)genModel, (ResourceSet)this.getResourceSet(), (IDiagnostician)this.diagnostician);
        if (Loglevel.DEBUG.compareTo((Enum)logger.getLoglevel()) >= 0) {
            logger.logInfo("-- begin dump of mappings");
            logger.logInfo(ETMapUtil.dumpMappings());
            logger.logInfo("-- end dump of mappings");
        }
        if (this.diagnostician.isFailed() || genModel == null) {
            logger.logError("errors in mapping");
            return 1;
        }
        logger.logInfo("-- starting code generation");
        this.mainGenerator.doGenerate(genModel.eResource());
        if (this.diagnostician.isFailed()) {
            logger.logError("errors during code generation");
            return 1;
        }
        return 0;
    }
}

