/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.simulator.runtime.distributions;

import org.eclipse.escet.cif.simulator.runtime.CifSimulatorException;
import org.eclipse.escet.cif.simulator.runtime.CifSimulatorMath;
import org.eclipse.escet.cif.simulator.runtime.distributions.CifRandomGenerator;
import org.eclipse.escet.cif.simulator.runtime.distributions.RealDistribution;
import org.eclipse.escet.common.java.Strings;

public class TriangleDistribution
extends RealDistribution {
    private final CifRandomGenerator randGen;
    private final double a;
    private final double b;
    private final double c;

    public TriangleDistribution(CifRandomGenerator randGen, double a, double b, double c) {
        this.randGen = randGen;
        this.a = a;
        this.b = b;
        this.c = c;
        if (a >= b) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The left-most position (the first parameter) is not smaller than the top position (the second parameter).";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
        if (b >= c) {
            String msg1 = Strings.fmt((String)"Invalid operation: %s.", (Object[])new Object[]{this});
            String msg2 = "The top position (the second parameter) is not smaller than the right-most position (the third parameter).";
            CifSimulatorException e = new CifSimulatorException(msg2);
            throw new CifSimulatorException(msg1, e);
        }
    }

    private TriangleDistribution(TriangleDistribution distribution) {
        this.randGen = distribution.randGen.copy();
        this.a = distribution.a;
        this.b = distribution.b;
        this.c = distribution.c;
    }

    @Override
    public RealDistribution copy() {
        return new TriangleDistribution(this);
    }

    @Override
    public double sample() {
        double beta = (this.b - this.a) / (this.c - this.a);
        double u = this.randGen.draw();
        double t = u < beta ? Math.sqrt(beta * u) : 1.0 - Math.sqrt((1.0 - beta) * (1.0 - u));
        return this.a + (this.c - this.a) * t;
    }

    @Override
    public String toString() {
        return Strings.fmt((String)"triangle(%s, %s, %s)", (Object[])new Object[]{CifSimulatorMath.realToStr(this.a), CifSimulatorMath.realToStr(this.b), CifSimulatorMath.realToStr(this.c)});
    }
}

