/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.escet.cif.common.CifEvalException;
import org.eclipse.escet.cif.common.CifEvalUtils;
import org.eclipse.escet.cif.metamodel.cif.IoDecl;
import org.eclipse.escet.cif.metamodel.cif.Specification;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgCopy;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgIn;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEvent;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIf;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventIfEntry;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgInEventSingle;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgMove;
import org.eclipse.escet.cif.metamodel.cif.cifsvg.SvgOut;
import org.eclipse.escet.cif.metamodel.cif.declarations.Event;
import org.eclipse.escet.cif.metamodel.cif.expressions.EventExpression;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.java.CifConstructors;
import org.eclipse.escet.common.app.framework.Paths;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Lists;
import org.eclipse.escet.common.java.Maps;
import org.eclipse.escet.common.java.Sets;
import org.eclipse.escet.common.java.Strings;

public abstract class SvgCodeGen {
    public static Map<SvgIn, Event> createEnvironmentEvents(List<SvgIn> svgIns, String cifSpecFileDir) {
        Specification environmentSpec = CifConstructors.newSpecification();
        Map environmentEvents = Maps.map();
        for (SvgIn svgIn : svgIns) {
            Assert.check((boolean)(svgIn.getEvent() == null ^ svgIn.getUpdates().isEmpty()));
            if (svgIn.getEvent() != null) continue;
            Assert.check((!svgIn.getUpdates().isEmpty() ? 1 : 0) != 0);
            String svgInId = SvgCodeGen.evalSvgStringExpr(svgIn.getId());
            String svgFileRelPath = svgIn.getSvgFile().getPath();
            String svgFileAbsPath = Paths.resolve((String)svgFileRelPath, (String)cifSpecFileDir);
            String svgFileNormRelPath = Paths.getRelativePath((String)svgFileAbsPath, (String)cifSpecFileDir);
            String eventName = Strings.fmt((String)"<svgin id \"%s\" file \"%s\">", (Object[])new Object[]{svgInId, svgFileNormRelPath});
            Event event = CifConstructors.newEvent();
            event.setName(eventName);
            environmentSpec.getDeclarations().add((Object)event);
            environmentEvents.put(svgIn, event);
        }
        Map sortedEnvironmentEvents = Maps.mapc((int)environmentEvents.size());
        Comparator<Map.Entry> comparator = Comparator.comparing(e -> ((Event)e.getValue()).getName(), Strings.SORTER);
        environmentEvents.entrySet().stream().sorted(comparator).forEach(e -> sortedEnvironmentEvents.put((SvgIn)e.getKey(), (Event)e.getValue()));
        return environmentEvents;
    }

    public static Set<Event> getSvgInEvents(List<SvgIn> svgIns) {
        Set svgInEvents = Sets.set();
        for (SvgIn svgIn : svgIns) {
            Assert.check((boolean)(svgIn.getEvent() == null ^ svgIn.getUpdates().isEmpty()));
            if (!svgIn.getUpdates().isEmpty()) continue;
            SvgInEvent svgInEvent = svgIn.getEvent();
            if (svgInEvent instanceof SvgInEventSingle) {
                SvgInEventSingle singleEvt = (SvgInEventSingle)svgInEvent;
                Event event = ((EventExpression)singleEvt.getEvent()).getEvent();
                svgInEvents.add(event);
                continue;
            }
            if (svgInEvent instanceof SvgInEventIf) {
                SvgInEventIf ifEvent = (SvgInEventIf)svgInEvent;
                for (SvgInEventIfEntry entry : ifEvent.getEntries()) {
                    Event event = ((EventExpression)entry.getEvent()).getEvent();
                    svgInEvents.add(event);
                }
                continue;
            }
            throw new RuntimeException("Unknown SVG input mapping event: " + String.valueOf(svgInEvent));
        }
        return svgInEvents;
    }

    public static CifSvgDecls filterAndGroup(List<IoDecl> svgDecls, String svgAbsPath, Map<String, String> svgPathsRelToAbs) {
        CifSvgDecls cifSvgDecls = new CifSvgDecls();
        for (IoDecl ioDecl : svgDecls) {
            if (ioDecl instanceof SvgCopy) {
                SvgCopy svgCopy = (SvgCopy)ioDecl;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgCopy.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgCopies.add(svgCopy);
                continue;
            }
            if (ioDecl instanceof SvgMove) {
                SvgMove svgMove = (SvgMove)ioDecl;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgMove.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgMoves.add(svgMove);
                continue;
            }
            if (ioDecl instanceof SvgOut) {
                SvgOut svgOut = (SvgOut)ioDecl;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgOut.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgOuts.add(svgOut);
                continue;
            }
            if (ioDecl instanceof SvgIn) {
                SvgIn svgIn = (SvgIn)ioDecl;
                if (!svgAbsPath.equals(svgPathsRelToAbs.get(svgIn.getSvgFile().getPath()))) continue;
                cifSvgDecls.svgIns.add(svgIn);
                continue;
            }
            throw new RuntimeException("Unexpected CIF/SVG declaration: " + String.valueOf(ioDecl));
        }
        return cifSvgDecls;
    }

    public static String evalSvgStringExpr(Expression expr) {
        try {
            return (String)CifEvalUtils.eval((Expression)expr, (boolean)false);
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    protected static double evalSvgNumberExpr(Expression expr) {
        try {
            Object rslt = CifEvalUtils.eval((Expression)expr, (boolean)false);
            if (rslt instanceof Integer) {
                return ((Integer)rslt).intValue();
            }
            if (rslt instanceof Double) {
                return (Double)rslt;
            }
            throw new RuntimeException("Number expected: " + String.valueOf(rslt));
        }
        catch (CifEvalException e) {
            throw new RuntimeException(e);
        }
    }

    public static class CifSvgDecls {
        public final List<SvgCopy> svgCopies = Lists.list();
        public final List<SvgMove> svgMoves = Lists.list();
        public final List<SvgOut> svgOuts = Lists.list();
        public final List<SvgIn> svgIns = Lists.list();

        public int size() {
            return this.svgCopies.size() + this.svgMoves.size() + this.svgOuts.size() + this.svgIns.size();
        }
    }
}

