/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.codegen.typeinfos;

import org.eclipse.escet.cif.codegen.CodeContext;
import org.eclipse.escet.cif.codegen.ExprCode;
import org.eclipse.escet.cif.codegen.assignments.Destination;
import org.eclipse.escet.cif.codegen.assignments.VariableInformation;
import org.eclipse.escet.cif.codegen.typeinfos.ContainerTypeInfo;
import org.eclipse.escet.cif.codegen.typeinfos.TypeInfo;
import org.eclipse.escet.cif.metamodel.cif.expressions.Expression;
import org.eclipse.escet.cif.metamodel.cif.expressions.ListExpression;
import org.eclipse.escet.cif.metamodel.cif.types.CifType;
import org.eclipse.escet.common.box.CodeBox;
import org.eclipse.escet.common.java.Assert;
import org.eclipse.escet.common.java.Strings;

public abstract class ArrayTypeInfo
extends ContainerTypeInfo {
    public final int length;

    public ArrayTypeInfo(CifType cifType, TypeInfo[] childTIs, int length) {
        super(cifType, childTIs);
        Assert.check((childTIs.length == 1 ? 1 : 0) != 0);
        this.length = length;
    }

    @Override
    public int getSize() {
        return this.length;
    }

    @Override
    protected String makeTypeName() {
        if (this.length < 0) {
            return "L" + this.childInfos[0].getTypeName();
        }
        return Strings.fmt((String)"A%d%s", (Object[])new Object[]{this.length, this.childInfos[0].getTypeName()});
    }

    public abstract String getElementTargetType();

    public abstract ExprCode getProjectedValue(ExprCode var1, ExprCode var2, Destination var3, CodeContext var4);

    public abstract CodeBox modifyContainer(VariableInformation var1, ExprCode var2, ExprCode var3, CodeContext var4);

    public abstract ExprCode convertLiteral(ListExpression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertSizeStdLib(Expression var1, Destination var2, CodeContext var3);

    public abstract ExprCode convertEmptyStdLib(Expression var1, Destination var2, CodeContext var3);
}

