/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime.data.random;

import org.eclipse.escet.chi.runtime.ChiCoordinator;
import org.eclipse.escet.chi.runtime.ChiSimulatorException;
import org.eclipse.escet.chi.runtime.data.random.DoubleDistribution;
import org.eclipse.escet.chi.runtime.data.random.GaussianGenerator;
import org.eclipse.escet.common.java.Strings;

public class LogNormalDistribution
extends DoubleDistribution {
    private GaussianGenerator gausGen;
    private final double mean;
    private final double sqrtVariance;

    public LogNormalDistribution(ChiCoordinator chiCoordinator, double mean, double variance) {
        super(chiCoordinator);
        if (variance <= 0.0) {
            String msg = Strings.fmt((String)"The Lognormal distribution expects the variance parameter to be bigger than 0, found %s instead.", (Object[])new Object[]{variance});
            throw new ChiSimulatorException(msg);
        }
        this.mean = mean;
        this.sqrtVariance = Math.sqrt(variance);
        this.gausGen = chiCoordinator.getGaussianGenerator();
    }

    @Override
    public double sample() {
        double normSample = this.gausGen.drawGaussian(this.mean, this.sqrtVariance);
        return Math.exp(normSample);
    }
}

