/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.weaving.internal.caching.j9;

import com.ibm.oti.shared.Shared;
import org.eclipse.equinox.service.weaving.ICachingServiceFactory;
import org.eclipse.equinox.weaving.internal.caching.j9.CachingServiceFactory;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class CachingServicePlugin
implements BundleActivator {
    public static boolean DEBUG;
    public static boolean verbose;

    static {
        verbose = Boolean.getBoolean("org.aspectj.osgi.verbose");
    }

    public void start(BundleContext context) throws Exception {
        if (DEBUG) {
            System.out.println("> CachingServicePlugin.start() context=" + String.valueOf(context));
        }
        this.loadOptions(context);
        if (this.shouldRegister()) {
            if (verbose) {
                System.err.println("[org.eclipse.equinox.weaving.caching.j9] info starting J9 caching service ...");
            }
            String name = ICachingServiceFactory.class.getName();
            CachingServiceFactory cachingServiceFactory = new CachingServiceFactory();
            context.registerService(name, (Object)cachingServiceFactory, null);
        } else if (verbose) {
            System.err.println("[org.eclipse.equinox.weaving.caching.j9] warning cannot start J9 caching service");
        }
        if (DEBUG) {
            System.out.println("< CachingServicePlugin.start()");
        }
    }

    public void stop(BundleContext context) throws Exception {
    }

    private void loadOptions(BundleContext context) {
        DebugOptions service = null;
        ServiceReference reference = context.getServiceReference(DebugOptions.class.getName());
        if (reference != null) {
            service = (DebugOptions)context.getService(reference);
        }
        if (service == null) {
            return;
        }
        try {
            DEBUG = service.getBooleanOption("org.aspectj.osgi.service.caching.j9/debug", false);
        }
        finally {
            context.ungetService(reference);
        }
    }

    private boolean shouldRegister() {
        boolean enabled;
        if (DEBUG) {
            System.out.println("> CachingServicePlugin.shouldRegister()");
        }
        try {
            Class.forName("com.ibm.oti.vm.VM");
            boolean sharing = Shared.isSharingEnabled();
            if (DEBUG) {
                System.out.println("- CachingServicePlugin.shouldRegister() sharing=" + sharing);
            }
            enabled = sharing;
        }
        catch (ClassNotFoundException ex) {
            if (DEBUG) {
                System.out.println("E CachingServicePlugin.shouldRegister() ex=" + String.valueOf(ex));
            }
            enabled = false;
        }
        if (DEBUG) {
            System.out.println("< CachingServicePlugin.shouldRegister() " + enabled);
        }
        return enabled;
    }
}

