/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.text;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.text.TokenWriter;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterTTL;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.riot.tokens.Token;
import org.apache.jena.sparql.util.FmtUtils;

public class TokenWriterText
implements TokenWriter {
    private static final boolean GAPS = true;
    private final AWriter out;
    private boolean inTuple = false;
    private boolean inSection = false;
    private final NodeFormatter fmt;
    private String label;

    public static TokenWriter create(OutputStream out) {
        return new TokenWriterText(out);
    }

    public static TokenWriter create(StringWriter out) {
        return new TokenWriterText(out);
    }

    public static TokenWriter create(AWriter out) {
        return new TokenWriterText(out);
    }

    private TokenWriterText(OutputStream out) {
        this(TokenWriterText.writer(out));
    }

    private static Writer writer(OutputStream out) {
        return IO.asUTF8(out);
    }

    private TokenWriterText(Writer out) {
        this(null, null, IO.wrap(out));
    }

    private TokenWriterText(AWriter out) {
        this(null, null, out);
    }

    private TokenWriterText(String label, NodeFormatter formatter, AWriter out) {
        this.fmt = formatter = new NodeFormatterBNode1();
        this.out = out;
        this.label = label;
    }

    @Override
    public void sendToken(Token token) {
        String string = this.tokenToString(token);
        this.write(string);
        this.gap(true);
    }

    @Override
    public void sendNode(Node node) {
        this.fmt.format(this.out, node);
        this.gap(false);
    }

    @Override
    public void sendString(String string) {
        this.fmt.formatLitString(this.out, string);
        this.gap(false);
    }

    @Override
    public void sendWord(String string) {
        this.write(string);
        this.gap(true);
    }

    @Override
    public void sendNumber(long number) {
        this.write(Long.toString(number));
        this.gap(true);
    }

    @Override
    public void startTuple() {
    }

    @Override
    public void endTuple() {
        if (!this.inTuple) {
            return;
        }
        this.out.write('.');
        this.out.write("\n");
        this.inTuple = false;
    }

    @Override
    public void close() {
        if (this.inTuple) {
            // empty if block
        }
        IO.close(this.out);
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    private String tokenToString(Token token) {
        switch (token.getType()) {
            case IRI: {
                return "<" + token.getImage() + ">";
            }
            case PREFIXED_NAME: {
                this.notImplemented(token);
                return null;
            }
            case BNODE: {
                return "_:" + token.getImage();
            }
            case STRING: {
                return "\"" + FmtUtils.stringEsc(token.getImage()) + "\"";
            }
            case LITERAL_LANG: {
                return "\"" + FmtUtils.stringEsc(token.getImage()) + "\"@" + token.getImage2();
            }
            case LITERAL_DT: {
                return "\"" + FmtUtils.stringEsc(token.getImage()) + "\"^^" + this.tokenToString(token.getSubToken2());
            }
            case INTEGER: 
            case DECIMAL: 
            case DOUBLE: {
                return token.getImage();
            }
            case KEYWORD: {
                return token.getImage();
            }
            case DOT: {
                return ".";
            }
            case VAR: {
                return "?" + token.getImage();
            }
            case COMMA: {
                return ",";
            }
            case SEMICOLON: {
                return ";";
            }
            case COLON: {
                return ":";
            }
            case LT: {
                return "<";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case GE: {
                return ">=";
            }
            case UNDERSCORE: {
                return "_";
            }
            case LBRACE: {
                return "{";
            }
            case RBRACE: {
                return "}";
            }
            case LPAREN: {
                return "(";
            }
            case RPAREN: {
                return ")";
            }
            case LBRACKET: {
                return "[";
            }
            case RBRACKET: {
                return "]";
            }
            case PLUS: {
                return "+";
            }
            case MINUS: {
                return "-";
            }
            case STAR: {
                return "*";
            }
            case SLASH: {
                return "/";
            }
            case RSLASH: {
                return "\\";
            }
            case HEX: {
                return "0x" + token.getImage();
            }
            case DIRECTIVE: {
                return "@" + token.getImage();
            }
            case VBAR: {
                return "|";
            }
            case AMPERSAND: {
                return "&";
            }
            case EQUALS: {
                return "=";
            }
        }
        this.notImplemented(token);
        return null;
    }

    private void gap(boolean required) {
        if (!required) {
            // empty if block
        }
        this.write(" ");
    }

    private void write(String string) {
        this.inTuple = true;
        this.out.write(string);
    }

    private static void exception(IOException ex) {
        throw new RiotException(ex);
    }

    private void notImplemented(Token token) {
        throw new RiotException("Unencodable token: " + token);
    }

    static class NodeFormatterBNode1
    extends NodeFormatterTTL {
        public NodeFormatterBNode1() {
            super(null, PrefixMapFactory.emptyPrefixMap());
        }

        @Override
        public void formatBNode(AWriter w, Node n) {
            this.formatBNode(w, n.getBlankNodeLabel());
        }

        @Override
        public void formatBNode(AWriter w, String label) {
            w.print("<_:");
            w.print(label);
            w.print(">");
        }
    }
}

