/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ecore.delegates.invocation;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epsilon.ecore.delegates.EolOperationDelegateContext;
import org.eclipse.epsilon.ecore.delegates.execution.EolOperation;
import org.eclipse.epsilon.ecore.delegates.invocation.EpsilonInvocationDelegate;
import org.eclipse.epsilon.ecore.delegates.invocation.InvocationUri;
import org.eclipse.epsilon.emc.emf.InMemoryEmfModel;
import org.eclipse.epsilon.eol.models.IModel;

public class EolInvocationDelegate
implements EpsilonInvocationDelegate {
    private final Map<Resource, InMemoryEmfModel> models = new HashMap<Resource, InMemoryEmfModel>();
    private final Set<InternalEObject> errors = new HashSet<InternalEObject>();
    private final EOperation eOperation;
    private final EolOperationDelegateContext delegateContext;
    private final InvocationUri uri;
    private EolOperation program;

    public EolInvocationDelegate(EOperation eOperation, EolOperationDelegateContext delegateContext, InvocationUri uri) {
        this.eOperation = eOperation;
        this.delegateContext = delegateContext;
        this.uri = uri;
    }

    public Object dynamicInvoke(InternalEObject target, EList<?> arguments) throws InvocationTargetException {
        if (this.errors.contains(target)) {
            return false;
        }
        if (this.program == null) {
            this.program = (EolOperation)this.delegateContext.parse(this.toEolOperation(this.expression()));
        }
        this.program.invokeWith(arguments);
        try {
            return this.program.execute((EObject)target, (IModel)this.models.computeIfAbsent(this.eOperation.eResource(), r -> new InMemoryEmfModel(r)));
        }
        catch (Throwable e) {
            this.errors.add(target);
            throw new InvocationTargetException(e);
        }
    }

    @Override
    public void reset() {
        this.program = null;
        this.errors.clear();
        this.models.clear();
    }

    private String toEolOperation(String body) {
        StringBuilder result = new StringBuilder();
        result.append("operation ");
        result.append(this.eOperation.getName());
        result.append("(");
        result.append(this.eOperation.getEParameters().stream().map(p -> p.getName()).collect(Collectors.joining(",")));
        result.append(")");
        result.append("{");
        result.append(body);
        result.append("}");
        return result.toString();
    }

    private String expression() {
        return this.uri.getEannotionValue(this.eOperation, "body");
    }
}

