/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.archive;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.eclipse.jgit.api.ArchiveCommand;
import org.eclipse.jgit.archive.BaseFormat;
import org.eclipse.jgit.archive.internal.ArchiveText;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.revwalk.RevCommit;

public final class TarFormat
extends BaseFormat
implements ArchiveCommand.Format<ArchiveOutputStream<TarArchiveEntry>> {
    private static final List<String> SUFFIXES = Collections.unmodifiableList(Arrays.asList(".tar"));

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s) throws IOException {
        return this.createArchiveOutputStream(s, Collections.emptyMap());
    }

    public ArchiveOutputStream createArchiveOutputStream(OutputStream s, Map<String, Object> o) throws IOException {
        TarArchiveOutputStream out = new TarArchiveOutputStream(s, StandardCharsets.UTF_8.name());
        out.setLongFileMode(3);
        out.setBigNumberMode(2);
        return this.applyFormatOptions((ArchiveOutputStream<? extends ArchiveEntry>)out, o);
    }

    public void putEntry(ArchiveOutputStream<TarArchiveEntry> out, ObjectId tree, String path, FileMode mode, ObjectLoader loader) throws IOException {
        if (mode == FileMode.SYMLINK) {
            TarArchiveEntry entry = new TarArchiveEntry((String)path, 50);
            entry.setLinkName(new String(loader.getCachedBytes(100), StandardCharsets.UTF_8));
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            return;
        }
        if (((String)path).endsWith("/") && mode != FileMode.TREE) {
            throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().pathDoesNotMatchMode, path, mode));
        }
        if (!((String)path).endsWith("/") && mode == FileMode.TREE) {
            path = (String)path + "/";
        }
        TarArchiveEntry entry = new TarArchiveEntry((String)path);
        if (tree instanceof RevCommit) {
            long t = (long)((RevCommit)tree).getCommitTime() * 1000L;
            entry.setModTime(t);
        }
        if (mode == FileMode.TREE) {
            out.putArchiveEntry((ArchiveEntry)entry);
            out.closeArchiveEntry();
            return;
        }
        if (mode != FileMode.REGULAR_FILE) {
            if (mode == FileMode.EXECUTABLE_FILE) {
                entry.setMode(mode.getBits());
            } else {
                throw new IllegalArgumentException(MessageFormat.format(ArchiveText.get().unsupportedMode, mode));
            }
        }
        entry.setSize(loader.getSize());
        out.putArchiveEntry((ArchiveEntry)entry);
        loader.copyTo(out);
        out.closeArchiveEntry();
    }

    public Iterable<String> suffixes() {
        return SUFFIXES;
    }

    public boolean equals(Object other) {
        return other instanceof TarFormat;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }
}

