/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.components;

import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.actions.ActionFactory;

public abstract class DropDownMenuAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private boolean showMenu;
    private IMenuCreator menuCreator = new MenuCreator();

    public DropDownMenuAction(String title) {
        super(title, 4);
    }

    public void run() {
        this.showMenu = true;
    }

    public void runWithEvent(Event event) {
        if (!this.isEnabled()) {
            return;
        }
        this.showMenu = false;
        this.run();
        Widget widget = event.widget;
        if (this.showMenu && widget instanceof ToolItem) {
            ToolItem item = (ToolItem)widget;
            Rectangle bounds = item.getBounds();
            event.detail = 4;
            event.x = bounds.x;
            event.y = bounds.y + bounds.height;
            item.notifyListeners(13, event);
        }
    }

    public IMenuCreator getMenuCreator() {
        return this.menuCreator;
    }

    private Menu fillMenu(Menu m) {
        for (IContributionItem item : this.getActions()) {
            item.fill(m, -1);
        }
        return m;
    }

    protected abstract Collection<IContributionItem> getActions();

    public void dispose() {
        this.menuCreator.dispose();
    }

    private class MenuCreator
    implements IMenuCreator {
        private Menu controlMenu;
        private Menu subMenu;

        private MenuCreator() {
        }

        private Menu dispose(Menu m) {
            if (m != null && !m.isDisposed()) {
                m.dispose();
            }
            return null;
        }

        public Menu getMenu(Menu parent) {
            this.subMenu = this.dispose(this.subMenu);
            this.subMenu = DropDownMenuAction.this.fillMenu(new Menu(parent));
            return this.subMenu;
        }

        public Menu getMenu(Control parent) {
            this.controlMenu = this.dispose(this.controlMenu);
            this.controlMenu = DropDownMenuAction.this.fillMenu(new Menu(parent));
            return this.controlMenu;
        }

        public void dispose() {
            this.controlMenu = this.dispose(this.controlMenu);
            this.subMenu = this.dispose(this.subMenu);
        }
    }
}

