/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.pages.common.client.handler;

import ee.jakarta.tck.pages.common.client.handler.ALLOWHandler;
import ee.jakarta.tck.pages.common.client.handler.ContentTypeHandler;
import ee.jakarta.tck.pages.common.client.handler.DefaultHandler;
import ee.jakarta.tck.pages.common.client.handler.Handler;
import ee.jakarta.tck.pages.common.client.handler.LocationHandler;
import ee.jakarta.tck.pages.common.client.handler.SetCookieHandler;
import ee.jakarta.tck.pages.common.client.handler.WWWAuthenticateHandler;

public class HandlerFactory {
    private static final String CONTENT_TYPE = "content-type";
    private static final String LOCATION = "location";
    private static final String SET_COOKIE = "set-cookie";
    private static final String ALLOW = "allow";
    private static final String WWW_AUTH = "www-authenticate";

    private HandlerFactory() {
    }

    public static Handler getHandler(String handlerName) {
        if (CONTENT_TYPE.equals(handlerName.toLowerCase())) {
            return ContentTypeHandler.getInstance();
        }
        if (LOCATION.equals(handlerName.toLowerCase())) {
            return LocationHandler.getInstance();
        }
        if (SET_COOKIE.equals(handlerName.toLowerCase())) {
            return SetCookieHandler.getInstance();
        }
        if (WWW_AUTH.equals(handlerName.toLowerCase())) {
            return WWWAuthenticateHandler.getInstance();
        }
        if (ALLOW.equals(handlerName.toLowerCase())) {
            return ALLOWHandler.getInstance();
        }
        return DefaultHandler.getInstance();
    }
}

