/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.callback.method;

import ee.jakarta.tck.persistence.core.callback.common.CallbackStatusIF;
import ee.jakarta.tck.persistence.core.callback.common.CallbackStatusImpl;
import ee.jakarta.tck.persistence.core.callback.common.GenerictListenerImpl;
import ee.jakarta.tck.persistence.core.callback.method.LineItem;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.PostLoad;
import jakarta.persistence.PostPersist;
import jakarta.persistence.PostRemove;
import jakarta.persistence.PostUpdate;
import jakarta.persistence.PrePersist;
import jakarta.persistence.PreRemove;
import jakarta.persistence.PreUpdate;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

@Entity
@Table(name="ORDER_TABLE")
public class Order
extends CallbackStatusImpl
implements Serializable,
CallbackStatusIF {
    private String id;
    private double totalPrice;
    private LineItem sampleLineItem;
    private Collection<LineItem> lineItemsCollection = new ArrayList<LineItem>();
    private GenerictListenerImpl callbackImpl = new GenerictListenerImpl();

    public Order() {
    }

    public Order(String id, double totalPrice) {
        this.id = id;
        this.totalPrice = totalPrice;
    }

    @Transient
    public GenerictListenerImpl getCallbackImpl() {
        return this.callbackImpl;
    }

    public void setCallbackImpl(GenerictListenerImpl callbackImpl) {
        this.callbackImpl = callbackImpl;
    }

    @PrePersist
    private void prePersist() {
        this.getCallbackImpl().prePersist(this);
    }

    @PostPersist
    private void postPersist() {
        this.getCallbackImpl().postPersist(this);
    }

    @PreRemove
    private void preRemove() {
        this.getCallbackImpl().preRemove(this);
    }

    @PostRemove
    private void postRemove() {
        this.getCallbackImpl().postRemove(this);
    }

    @PreUpdate
    private void preUpdate() {
        this.getCallbackImpl().preUpdate(this);
    }

    @PostUpdate
    private void postUpdate() {
        this.getCallbackImpl().postUpdate(this);
    }

    @PostLoad
    private void postLoad() {
        this.getCallbackImpl().postLoad(this);
    }

    @Id
    @Column(name="ID")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Column(name="TOTALPRICE")
    public double getTotalPrice() {
        return this.totalPrice;
    }

    public void setTotalPrice(double price) {
        this.totalPrice = price;
    }

    @OneToOne(cascade={CascadeType.REMOVE})
    @JoinColumn(name="FK0_FOR_LINEITEM_TABLE")
    public LineItem getSampleLineItem() {
        return this.sampleLineItem;
    }

    public void setSampleLineItem(LineItem l) {
        this.sampleLineItem = l;
    }

    @OneToMany(mappedBy="order", cascade={CascadeType.ALL})
    public Collection<LineItem> getLineItemsCollection() {
        return this.lineItemsCollection;
    }

    public void setLineItemsCollection(Collection<LineItem> c) {
        this.lineItemsCollection = c;
    }

    public void addLineItem(LineItem p) {
        this.getLineItemsCollection().add(p);
    }
}

