/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.override.attributeoverride;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.override.attributeoverride.LawBook;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static final int ENTITY_ID = 3039;
    private static final String NAME = "Cheese";
    private static final String PUBLISHER = "Johnson";
    private static final int COST = 20;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            this.logErr("Exception:test failed ", e);
        }
    }

    public void testNoAttributeOverrideAnnotation() throws Exception {
        block6: {
            LawBook book = new LawBook();
            this.getEntityTransaction().begin();
            book.setCategory("Motivational");
            book.setId(3039);
            book.setName(NAME);
            book.setPublisher(PUBLISHER);
            book.setCost(20);
            this.getEntityManager().persist((Object)book);
            this.getEntityManager().flush();
            try {
                List result = this.getEntityManager().createQuery("SELECT b FROM LawBook b where b.name= :name").setParameter("name", (Object)NAME).getResultList();
                if (result.size() == 1) {
                    this.logTrace("test Overriding Attributes passed");
                    break block6;
                }
                throw new Exception("Expected the size to be 1  but it is -" + result.size());
            }
            catch (Exception e) {
                throw new Exception("Exception thrown while testing testNoAttributeOverrideAnnotation" + e);
            }
            finally {
                this.getEntityManager().remove((Object)book);
                this.getEntityTransaction().commit();
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("Cleanup data");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM LAWBOOK").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

