/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.mapkey;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Department;
import ee.jakarta.tck.persistence.core.annotations.mapkey.Employee;
import java.util.HashMap;

public class Client
extends PMClientBase {
    protected Employee[] empRef = new Employee[10];
    protected static Department[] deptRef = new Department[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestDataCommon() throws Exception {
        try {
            this.logTrace("createTestDataCommon");
            this.getEntityTransaction().begin();
            this.logTrace("Create 2 Departments");
            Client.deptRef[0] = new Department(1, "Marketing");
            Client.deptRef[1] = new Department(2, "Administration");
            this.logTrace("Start to persist departments ");
            for (Department dept : deptRef) {
                if (dept == null) continue;
                this.getEntityManager().persist((Object)dept);
                this.logTrace("persisted department " + dept.getName());
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTestData() throws Exception {
        try {
            this.logTrace("createTestData");
            this.createTestDataCommon();
            this.getEntityTransaction().begin();
            this.logTrace("Create 5 employees");
            this.empRef[0] = new Employee(1, "Alan", "Frechette");
            this.empRef[0].setDepartment(deptRef[0]);
            this.empRef[1] = new Employee(2, "Arthur", "Frechette");
            this.empRef[1].setDepartment(deptRef[1]);
            this.empRef[2] = new Employee(3, "Shelly", "McGowan");
            this.empRef[2].setDepartment(deptRef[0]);
            this.empRef[3] = new Employee(4, "Robert", "Bissett");
            this.empRef[3].setDepartment(deptRef[1]);
            this.empRef[4] = new Employee(5, "Stephen", "DMilla");
            this.empRef[4].setDepartment(deptRef[0]);
            HashMap<String, Employee> link = new HashMap<String, Employee>();
            link.put(this.empRef[0].getLastName(), this.empRef[0]);
            link.put(this.empRef[2].getLastName(), this.empRef[2]);
            link.put(this.empRef[4].getLastName(), this.empRef[4]);
            deptRef[0].setLastNameEmployees(link);
            HashMap<String, Employee> link1 = new HashMap<String, Employee>();
            link1.put(this.empRef[1].getLastName(), this.empRef[1]);
            link1.put(this.empRef[3].getLastName(), this.empRef[3]);
            deptRef[1].setLastNameEmployees(link1);
            this.logTrace("Start to persist employees ");
            for (Employee emp : this.empRef) {
                if (emp == null) continue;
                this.getEntityManager().persist((Object)emp);
                this.logTrace("persisted employee " + emp.getId());
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Unexpected Exception creating test data:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in rollback:", re);
            }
        }
    }

    public void cleanup() throws Exception {
        this.logTrace("cleanup");
        this.removeTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    protected void removeTestData() {
        this.logTrace("removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in RemoveSchemaData:", re);
            }
        }
    }
}

