/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.commonee;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.commonee.Tests;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.PostActivate;
import jakarta.ejb.PrePassivate;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

@Stateful
@Remote(value={Tests.class})
public class TestsEJB
implements Tests {
    @Resource
    private SessionContext sessionContext;
    private Properties harnessProps = null;
    private TSNamingContext nctx = null;
    private transient Destination testDestination = null;
    private transient ConnectionFactory cf = null;
    private transient Connection conn = null;
    private transient Queue queue = null;
    private transient QueueConnectionFactory qcf = null;
    private transient QueueConnection qconn = null;
    private static final String TESTQUEUENAME = "java:comp/env/jms/MY_QUEUE";
    private static final String TESTTOPICNAME = "java:comp/env/jms/MY_TOPIC";
    private static final String QUEUECONNECTIONFACTORY = "java:comp/env/jms/MyQueueConnectionFactory";
    private static final String DURABLETOPICCONNECTIONFACTORY = "java:comp/env/jms/MyTopicConnectionFactory";
    private TextMessage messageSent = null;
    private BytesMessage messageSentB = null;
    private String username = null;
    private String password = null;
    private long timeout;
    private boolean booleanValue = false;
    private byte byteValue = (byte)127;
    private byte byteValue1 = (byte)-12;
    private int byteValue2 = 244;
    private byte[] bytesValue = new byte[]{127, -127, 1, 0};
    private byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
    private byte[] byteValues = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
    private byte[] byteValues2 = new byte[]{11, 12, 13, 14, 15, 16, 17, 18, 19, 20};
    private byte[] byteValuesReturned = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private byte[] byteValuesReturned2 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private char charValue = (char)90;
    private double doubleValue = 6.02E23;
    private float floatValue = 6.02E23f;
    private int intValue = Integer.MAX_VALUE;
    private long longValue = Long.MAX_VALUE;
    private Integer nInteger = Integer.MIN_VALUE;
    private short shortValue = Short.MIN_VALUE;
    private short shortValue1 = (short)-28679;
    private int shortValue2 = 36857;
    private String utfValue = "what";
    private String stringValue = "Map Message Test";
    private String sTesting = "Testing StreamMessages";
    private String type = "JMSTCKTESTMSG";
    private String jmsCorrelationID = "JMSTCKCorrelationID";
    private int priority = 2;
    private long forever = 0L;

    public TestsEJB() {
        TestUtil.logTrace("TestsEJB => default constructor called");
    }

    @PostConstruct
    public void postConstruct() {
        TestUtil.logTrace("postConstruct");
        try {
            TestUtil.logMsg("obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (Exception e) {
            TestUtil.logErr("Error obtaining naming context: ", e);
            throw new EJBException("postConstruct: Failed!", e);
        }
    }

    @PostActivate
    public void activate() {
        TestUtil.logTrace("activate");
        try {
            this.common_Q();
            this.setup_Q();
        }
        catch (Exception e) {
            TestUtil.logErr("Error during common Queue setup: ", e);
            throw new EJBException("activate: Failed!", e);
        }
    }

    @PrePassivate
    public void passivate() {
        TestUtil.logTrace("passivate");
        this.testDestination = null;
        this.cf = null;
        this.conn = null;
        this.queue = null;
        this.qcf = null;
        this.qconn = null;
    }

    @Override
    @Remove
    public void remove() {
        TestUtil.logTrace("remove");
    }

    @Override
    public void initLogging(Properties p) {
        TestUtil.logTrace("initLogging");
        this.harnessProps = p;
        try {
            TestUtil.logMsg("initialize remote logging");
            TestUtil.init(p);
            this.timeout = Long.parseLong(TestUtil.getProperty(this.harnessProps, "jms_timeout"));
            this.username = TestUtil.getProperty(this.harnessProps, "user");
            this.password = TestUtil.getProperty(this.harnessProps, "password");
            if (this.timeout < 1L) {
                throw new EJBException("'jms_timeout' (milliseconds) in ts.jte must be > 0");
            }
            if (this.username == null) {
                throw new EJBException("'user' in ts.jte must be null");
            }
            if (this.password == null) {
                throw new EJBException("'password' in ts.jte must be null");
            }
            if (this.sessionContext == null) {
                throw new EJBException("@Resource injection failed");
            }
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace(e);
            throw new EJBException("initLogging: Failed!", (Exception)e);
        }
    }

    private void common_Q() throws Exception {
        TestUtil.logTrace("Getting ConnectionFactory java:comp/env/jms/MyQueueConnectionFactory");
        this.cf = (ConnectionFactory)this.nctx.lookup(QUEUECONNECTIONFACTORY);
        TestUtil.logTrace("Getting Destination java:comp/env/jms/MY_QUEUE");
        this.testDestination = (Destination)this.nctx.lookup(TESTQUEUENAME);
        TestUtil.logTrace("Creating Connection with username, " + this.username + " password, " + this.password);
        this.conn = this.cf.createConnection(this.username, this.password);
    }

    private void setup_Q() throws Exception {
        TestUtil.logTrace("Getting ConnectionFactory java:comp/env/jms/MyQueueConnectionFactory");
        this.qcf = (QueueConnectionFactory)this.nctx.lookup(QUEUECONNECTIONFACTORY);
        TestUtil.logTrace("Getting Queuejava:comp/env/jms/MY_QUEUE");
        this.queue = (Queue)this.nctx.lookup(TESTQUEUENAME);
        TestUtil.logTrace("Creating QueueConnection with username, " + this.username + " password, " + this.password);
        this.qconn = this.qcf.createQueueConnection(this.username, this.password);
    }

    private void common_T() throws Exception {
        TestUtil.logTrace("Getting ConnectionFactory java:comp/env/jms/MyTopicConnectionFactory");
        this.cf = (ConnectionFactory)this.nctx.lookup(DURABLETOPICCONNECTIONFACTORY);
        TestUtil.logTrace("Getting Destination java:comp/env/jms/MY_TOPIC");
        this.testDestination = (Destination)this.nctx.lookup(TESTTOPICNAME);
        TestUtil.logTrace("Creating Connection with  username, " + this.username + " password, " + this.password);
        this.conn = this.cf.createConnection(this.username, this.password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendTextMessage_CQ(String TestName, String message) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.common_Q();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(false, 1);
            TestUtil.logTrace("Creating messageProducer");
            MessageProducer sender = sess.createProducer(this.testDestination);
            TestUtil.logMsg("Creating 1 TextMessage");
            this.messageSent = sess.createTextMessage();
            this.messageSent.setText(message);
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", TestName);
            TestUtil.logMsg("Sending a TextMessage");
            timeBeforeSend = System.currentTimeMillis();
            sender.send((Message)this.messageSent);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)this.messageSent, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendTextMessage_CQ");
            TestUtil.printStackTrace(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in sendTextMessage_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in sendTextMessage_CQ" + ce.getMessage(), ce);
                }
            }
        }
        return valueAtSend;
    }

    private ArrayList logPropertyAtSend(Message messageSent, long timeBeforeSend, long timeAfterSend) throws Exception {
        ArrayList<Object> valueAtSend = new ArrayList<Object>(9);
        valueAtSend.add(0, timeBeforeSend);
        TestUtil.logTrace("Time before send..." + String.valueOf(valueAtSend.get(0)));
        valueAtSend.add(1, timeAfterSend);
        TestUtil.logTrace("Time after send...." + String.valueOf(valueAtSend.get(1)));
        valueAtSend.add(2, messageSent.getJMSTimestamp());
        TestUtil.logTrace("JMSTimeStamp......." + String.valueOf(valueAtSend.get(2)));
        valueAtSend.add(3, messageSent.getJMSExpiration());
        TestUtil.logTrace("JMSExpiration......" + String.valueOf(valueAtSend.get(3)));
        valueAtSend.add(4, messageSent.getJMSDestination());
        TestUtil.logTrace("JMSDestination....." + String.valueOf(valueAtSend.get(4)));
        valueAtSend.add(5, Long.valueOf(messageSent.getJMSPriority()));
        TestUtil.logTrace("JMSPriority........" + String.valueOf(valueAtSend.get(5)));
        valueAtSend.add(6, Long.valueOf(messageSent.getJMSDeliveryMode()));
        TestUtil.logTrace("JMSDeliveryMode...." + String.valueOf(valueAtSend.get(6)));
        valueAtSend.add(7, messageSent.getJMSMessageID());
        TestUtil.logTrace("JMSMessageID......." + String.valueOf(valueAtSend.get(7)));
        valueAtSend.add(8, messageSent.getJMSCorrelationID());
        TestUtil.logTrace("JMSCorrelationID..." + String.valueOf(valueAtSend.get(8)));
        return valueAtSend;
    }

    @Override
    public String receiveTextMessage_CQ() {
        TextMessage receivedM = null;
        String tmp = null;
        try {
            this.common_Q();
            this.conn.start();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(false, 1);
            TestUtil.logTrace("Creating MessageConsumer");
            MessageConsumer receiver = sess.createConsumer(this.testDestination);
            receivedM = (TextMessage)receiver.receive(this.timeout);
            tmp = receivedM.getText();
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in receiveTextMessage_CQ: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in receiveTextMessage_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in receiveTextMessage_CQ" + ce.getMessage(), ce);
                }
            }
        }
        return tmp;
    }

    @Override
    public String receiveMessageS_CQ(String selector) {
        TextMessage receivedM = null;
        String tmp = null;
        try {
            this.common_Q();
            this.conn.start();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace("Creating MessageConsumer");
            MessageConsumer receiver = sess.createConsumer(this.testDestination, selector);
            receivedM = (TextMessage)receiver.receive(this.timeout);
            tmp = receivedM.getText();
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in receiveMessageS_CQ: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in receiveMessageS_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in receiveMessageS_CQ" + ce.getMessage(), ce);
                }
            }
        }
        return tmp;
    }

    @Override
    public int browseTextMessage_CQ(int num, String message) {
        QueueBrowser browseAll = null;
        int msgCount = 0;
        int totalMsg = 0;
        TextMessage tempMsg = null;
        try {
            this.common_Q();
            this.conn.start();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace("Creating QueueBrowser");
            browseAll = sess.createBrowser((Queue)this.testDestination);
            Enumeration msgs = null;
            int i = 0;
            do {
                msgCount = 0;
                totalMsg = 0;
                msgs = browseAll.getEnumeration();
                TestUtil.logTrace("getting Enumeration " + ++i);
                while (msgs.hasMoreElements()) {
                    tempMsg = (TextMessage)msgs.nextElement();
                    ++totalMsg;
                    if (tempMsg.getText().indexOf(message) < 0) continue;
                    ++msgCount;
                }
                TestUtil.logTrace("found " + msgCount + " messages total in browser");
            } while (msgCount < num && i < 10);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to browse message in browseTextMessage_CQ: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in browseTextMessage_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in browseTextMessage_CQ" + ce.getMessage(), ce);
                }
            }
        }
        return totalMsg;
    }

    @Override
    public int browseMessageS_CQ(int num, String message, String selector) {
        QueueBrowser selectiveBrowser = null;
        int msgCount = 0;
        int totalMsg = 0;
        TextMessage tempMsg = null;
        try {
            this.common_Q();
            this.conn.start();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace("Creating QueueBrowser");
            selectiveBrowser = sess.createBrowser((Queue)this.testDestination, selector);
            Enumeration msgs = null;
            int i = 0;
            do {
                msgCount = 0;
                totalMsg = 0;
                msgs = selectiveBrowser.getEnumeration();
                TestUtil.logTrace("getting Enumeration " + ++i);
                while (msgs.hasMoreElements()) {
                    tempMsg = (TextMessage)msgs.nextElement();
                    ++totalMsg;
                    if (tempMsg.getText().indexOf(message) < 0) continue;
                    ++msgCount;
                }
                TestUtil.logTrace("found " + msgCount + " messages total in browser");
            } while (msgCount < num && i < 10);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to browse message in browseMessageS_CQ: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in browseMessageS_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in browseMessageS_CQ" + ce.getMessage(), ce);
                }
            }
        }
        return totalMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendMessageP_CQ(String TestName, String message, boolean val) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.common_Q();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(false, 1);
            TestUtil.logTrace("Creating messageProducer");
            MessageProducer sender = sess.createProducer(this.testDestination);
            TestUtil.logMsg("Creating 1 TextMessage");
            this.messageSent = sess.createTextMessage();
            this.messageSent.setText(message);
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", TestName);
            this.messageSent.setBooleanProperty("lastMessage", val);
            TestUtil.logMsg("Sending a TextMessage");
            timeBeforeSend = System.currentTimeMillis();
            sender.send((Message)this.messageSent);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)this.messageSent, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendMessageP_CQ");
            TestUtil.printStackTrace(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in sendMessageP_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in sendMessageP_CQ" + ce.getMessage(), ce);
                }
            }
        }
        return valueAtSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendMessagePP_CQ(String TestName, String message, boolean val, String p, String value) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.common_Q();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(false, 1);
            TestUtil.logTrace("Creating messageProducer");
            MessageProducer sender = sess.createProducer(this.testDestination);
            TestUtil.logMsg("Creating 1 TextMessage");
            this.messageSent = sess.createTextMessage();
            this.messageSent.setText(message);
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", TestName);
            this.messageSent.setStringProperty(p, value);
            this.messageSent.setBooleanProperty("lastMessage", val);
            TestUtil.logMsg("Sending a TextMessage");
            timeBeforeSend = System.currentTimeMillis();
            sender.send((Message)this.messageSent);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)this.messageSent, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendMessagePP_CQ");
            TestUtil.printStackTrace(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in sendMessagePP_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in sendMessagePP_CQ" + ce.getMessage(), ce);
                }
            }
        }
        return valueAtSend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendTextMessage_CT(String TestName, String message) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.common_T();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace("Creating messageProducer");
            MessageProducer sender = sess.createProducer(this.testDestination);
            TestUtil.logMsg("Creating 1 TextMessage");
            this.messageSent = sess.createTextMessage();
            this.messageSent.setText(message);
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", TestName);
            TestUtil.logMsg("Sending a TextMessage");
            timeBeforeSend = System.currentTimeMillis();
            sender.send((Message)this.messageSent);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)this.messageSent, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendTextMessage_CT");
            TestUtil.printStackTrace(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in sendTextMessage_CT");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in sendTextMessage_CT" + ce.getMessage(), ce);
                }
            }
        }
        return valueAtSend;
    }

    @Override
    public String receiveTextMessage_CT() {
        TextMessage receivedM = null;
        String tmp = null;
        try {
            this.common_T();
            this.conn.start();
            TestUtil.logTrace("Creating Session");
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace("Creating MessageConsumer");
            MessageConsumer receiver = sess.createConsumer(this.testDestination);
            receivedM = (TextMessage)receiver.receive(this.timeout);
            tmp = receivedM.getText();
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in receiveTextMessage_CT: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in receiveTextMessage_CT");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in receiveTextMessage_CT" + ce.getMessage(), ce);
                }
            }
        }
        return tmp;
    }

    @Override
    public int getAck_CT() {
        int mode = 0;
        try {
            this.common_T();
            Session sess = this.conn.createSession(true, 1);
            mode = sess.getAcknowledgeMode();
            TestUtil.logTrace("AcknowledgeMode is set at 1");
            TestUtil.logTrace("AcknowledgeMode returned as " + mode);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to getAcknowledgeMode: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in getAck_CT");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in getAck_CT():" + ce.getMessage(), ce);
                }
            }
        }
        return mode;
    }

    @Override
    public int getAck_CQ() {
        int mode = 0;
        try {
            this.common_Q();
            Session sess = this.conn.createSession(false, 1);
            mode = sess.getAcknowledgeMode();
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to getAcknowledgeMode: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in getAck_CQ");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in getAck_CQ():" + ce.getMessage(), ce);
                }
            }
        }
        return mode;
    }

    @Override
    public boolean getQueue() {
        QueueBrowser browseAll = null;
        boolean pass = true;
        try {
            this.common_Q();
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace("Creating QueueBrowser");
            browseAll = sess.createBrowser((Queue)this.testDestination);
            if (!browseAll.getQueue().toString().equals(this.testDestination.toString())) {
                pass = false;
                TestUtil.logErr("Error: QueueBrowser.getQueue test failed");
                TestUtil.logErr("QueueBrowser.getQueue=" + browseAll.getQueue().toString() + ".");
                TestUtil.logErr("testDestination=" + this.testDestination.toString() + ".");
            }
            browseAll.close();
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to getQueue: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in getQueue");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in getQueue():" + ce.getMessage(), ce);
                }
            }
        }
        return pass;
    }

    @Override
    public boolean getSelector(String selector) {
        QueueBrowser selectiveBrowser = null;
        boolean pass = true;
        try {
            this.common_Q();
            Session sess = this.conn.createSession(true, 1);
            TestUtil.logTrace("Creating QueueBrowser");
            selectiveBrowser = sess.createBrowser((Queue)this.testDestination, selector);
            String tmp = selectiveBrowser.getMessageSelector();
            if (tmp.indexOf("TEST") < 0 || tmp.indexOf("test") < 0) {
                pass = false;
                TestUtil.logErr("Error: QueueBrowser.getMessageSelector test failed");
                TestUtil.logErr("selectiveBrowser.getMessageSelector()=" + selectiveBrowser.getMessageSelector());
            }
            selectiveBrowser.close();
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to getMessageSelector: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.conn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in getSelector");
                    this.conn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in getSelector():" + ce.getMessage(), ce);
                }
            }
        }
        return pass;
    }

    @Override
    public ArrayList sendTextMessage_Q(String TestName) {
        return this.sendTextMessage_Q(TestName, null, false, 2, true);
    }

    @Override
    public ArrayList sendTextMessage_Q(String TestName, String text) {
        return this.sendTextMessage_Q(TestName, text, false, 2, true);
    }

    @Override
    public ArrayList sendTextMessage_Q(String TestName, boolean setDest) {
        return this.sendTextMessage_Q(TestName, null, setDest, 2, true);
    }

    @Override
    public ArrayList sendTextMessage_Q(String TestName, boolean setDest, int mode) {
        return this.sendTextMessage_Q(TestName, null, setDest, mode, true);
    }

    public ArrayList sendTextMessage_Q(String TestName, String text, boolean setDest, int mode) {
        return this.sendTextMessage_Q(TestName, text, setDest, mode, true);
    }

    @Override
    public ArrayList sendTextMessage_Q(String TestName, String text, Queue testQueue) {
        return this.sendTextMessage_Q(TestName, text, false, 2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList sendTextMessage_Q(String TestName, String text, boolean setDest, int mode, boolean setQueue) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        QueueSender qsender = null;
        try {
            this.setup_Q();
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueSender");
            qsender = setQueue ? qsess.createSender(this.queue) : qsess.createSender((Queue)null);
            qsender.setPriority(this.priority);
            qsender.setTimeToLive(this.forever);
            if (mode != 2) {
                qsender.setDeliveryMode(mode);
            }
            TestUtil.logMsg("Creating 1 TextMessage");
            this.messageSent = qsess.createTextMessage();
            if (text != null) {
                this.messageSent.setText(text);
            }
            this.messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", TestName);
            this.messageSent.setJMSCorrelationID(this.jmsCorrelationID);
            this.messageSent.setJMSType(this.type);
            if (setDest) {
                this.messageSent.setJMSReplyTo((Destination)this.queue);
            }
            TestUtil.logMsg("Sending a TextMessage");
            timeBeforeSend = System.currentTimeMillis();
            if (setQueue) {
                qsender.send((Message)this.messageSent);
            } else {
                qsender.send(this.queue, (Message)this.messageSent);
            }
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)this.messageSent, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendTextMessage_Q", e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing QueueConnection in sendTextMessage_Q");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing QueueConnection in sendTextMessage_Q", ce);
                }
            }
        }
        return valueAtSend;
    }

    @Override
    public ArrayList sendFullBytesMessage_Q(String TestName) {
        return this.sendBytesMessage_Q(TestName, false, 2);
    }

    @Override
    public ArrayList sendBytesMessage_Q(String TestName, boolean setDest) {
        return this.sendBytesMessage_Q(TestName, setDest, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendBytesMessage_Q(String TestName, boolean setDest, int mode) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.setup_Q();
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueSender");
            QueueSender qsender = qsess.createSender(this.queue);
            qsender.setPriority(this.priority);
            qsender.setTimeToLive(this.forever);
            if (mode != 2) {
                qsender.setDeliveryMode(mode);
            }
            TestUtil.logMsg("Creating 1 BytesMessage");
            this.messageSentB = qsess.createBytesMessage();
            this.messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", TestName);
            this.messageSentB.setJMSCorrelationID(this.jmsCorrelationID);
            this.messageSentB.setJMSType(this.type);
            if (setDest) {
                this.messageSentB.setJMSReplyTo((Destination)this.queue);
            }
            TestUtil.logMsg("Writing one of each primitive type to the message");
            this.messageSentB.writeBoolean(this.booleanValue);
            this.messageSentB.writeByte(this.byteValue);
            this.messageSentB.writeByte(this.byteValue1);
            this.messageSentB.writeChar(this.charValue);
            this.messageSentB.writeDouble(this.doubleValue);
            this.messageSentB.writeFloat(this.floatValue);
            this.messageSentB.writeInt(this.intValue);
            this.messageSentB.writeLong(this.longValue);
            this.messageSentB.writeObject((Object)this.nInteger);
            this.messageSentB.writeShort(this.shortValue);
            this.messageSentB.writeShort(this.shortValue1);
            this.messageSentB.writeUTF(this.utfValue);
            this.messageSentB.writeBytes(this.bytesValue);
            this.messageSentB.writeBytes(this.bytesValue, 0, 1);
            TestUtil.logMsg("Sending a BytesMessage");
            timeBeforeSend = System.currentTimeMillis();
            qsender.send((Message)this.messageSentB);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)this.messageSentB, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendFullBytesMessage_Q", e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing QueueConnection in sendFullBytesMessage_Q");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing QueueConnection in sendFullBytesMessage_Q", ce);
                }
            }
        }
        return valueAtSend;
    }

    @Override
    public boolean verifyFullBytesMessage() {
        TestUtil.logTrace("In verifyFullBytesMessage ...");
        BytesMessage messageReceived = null;
        try {
            this.setup_Q();
            this.qconn.start();
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueReceiver");
            QueueReceiver qreceiver = qsess.createReceiver(this.queue);
            messageReceived = (BytesMessage)qreceiver.receive(this.timeout);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in verifyFullBytesMessage: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in verifyFullBytesMessage");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in verifyFullBytesMessage", ce);
                }
            }
        }
        boolean pass = true;
        try {
            if (!messageReceived.readBoolean() == this.booleanValue) {
                TestUtil.logErr("Error: boolean not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readByte() != this.byteValue) {
                TestUtil.logErr("Error: Byte not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            int tmp = messageReceived.readUnsignedByte();
            if (tmp != this.byteValue2) {
                TestUtil.logErr("Fail: readUnsignedByte not returned expected value: " + tmp);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readChar() != this.charValue) {
                TestUtil.logErr("Fail: char not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readDouble() != this.doubleValue) {
                TestUtil.logErr("Fail: double not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readFloat() != this.floatValue) {
                TestUtil.logErr("Fail: float not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readInt() != this.intValue) {
                TestUtil.logErr("Fail: int not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readLong() != this.longValue) {
                TestUtil.logErr("Fail: long not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readInt() != this.nInteger.intValue()) {
                TestUtil.logErr("Fail: Integer not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (messageReceived.readShort() != this.shortValue) {
                TestUtil.logErr("Fail: short not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            int tmps = messageReceived.readUnsignedShort();
            if (tmps != this.shortValue2) {
                TestUtil.logErr("Fail: readUnsignedShort did not return expected value: " + tmps);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            if (!messageReceived.readUTF().equals(this.utfValue)) {
                TestUtil.logErr("Fail: UTF not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            int nCount = messageReceived.readBytes(this.bytesValueRecvd);
            for (int i = 0; i < nCount; ++i) {
                if (this.bytesValueRecvd[i] == this.bytesValue[i]) continue;
                TestUtil.logErr("Fail: bytes value incorrect");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            int nCount = messageReceived.readBytes(this.bytesValueRecvd);
            TestUtil.logTrace("count returned " + nCount);
            if (this.bytesValueRecvd[0] != this.bytesValue[0]) {
                TestUtil.logErr("Fail: bytes value incorrect");
                pass = false;
            }
            if (nCount != 1) {
                TestUtil.logErr("Error: count not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        try {
            long length = 37L;
            long tmpl = messageReceived.getBodyLength();
            if (tmpl < length) {
                TestUtil.logErr("getBodyLength test failed with incorrect length=" + tmpl);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: unexpected exception was thrown", e);
            pass = false;
        }
        return pass;
    }

    @Override
    public ArrayList sendFullMapMessage_Q(String testName) {
        return this.sendMapMessage_Q(testName, false, 2);
    }

    @Override
    public ArrayList sendMapMessage_Q(String testName, boolean setDest) {
        return this.sendMapMessage_Q(testName, setDest, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendMapMessage_Q(String testName, boolean setDest, int mode) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.setup_Q();
            MapMessage messageSent = null;
            Object msgReceivedM = null;
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueSender");
            QueueSender qsender = qsess.createSender(this.queue);
            qsender.setPriority(this.priority);
            qsender.setTimeToLive(this.forever);
            if (mode != 2) {
                qsender.setDeliveryMode(mode);
            }
            TestUtil.logMsg("Creating 1 MapMessage");
            messageSent = qsess.createMapMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSent.setJMSCorrelationID(this.jmsCorrelationID);
            messageSent.setJMSType(this.type);
            if (setDest) {
                messageSent.setJMSReplyTo((Destination)this.queue);
            }
            messageSent.setBoolean("booleanValue", this.booleanValue);
            messageSent.setByte("byteValue", this.byteValue);
            messageSent.setBytes("bytesValue", this.bytesValue);
            messageSent.setBytes("bytesValue2", this.bytesValue, 0, 1);
            messageSent.setChar("charValue", this.charValue);
            messageSent.setDouble("doubleValue", this.doubleValue);
            messageSent.setFloat("floatValue", this.floatValue);
            messageSent.setInt("intValue", this.intValue);
            messageSent.setLong("longValue", this.longValue);
            messageSent.setObject("nInteger", (Object)this.nInteger);
            messageSent.setShort("shortValue", this.shortValue);
            messageSent.setString("stringValue", this.stringValue);
            messageSent.setString("nullTest", null);
            TestUtil.logTrace("Sending a MapMessage...");
            timeBeforeSend = System.currentTimeMillis();
            qsender.send((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)messageSent, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendFullMapMessage_Q", e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing QueueConnection in sendFullMapMessage_Q");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing QueueConnection in sendFullMapMessage_Q", ce);
                }
            }
        }
        return valueAtSend;
    }

    @Override
    public boolean verifyFullMapMessage() {
        byte[] b;
        boolean pass = true;
        MapMessage msgReceivedM = null;
        try {
            this.setup_Q();
            this.qconn.start();
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueReceiver");
            QueueReceiver qreceiver = qsess.createReceiver(this.queue);
            msgReceivedM = (MapMessage)qreceiver.receive(this.timeout);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in verifyFullMapMessage: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in verifyFullMapMessage");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in verifyFullMapMessage", ce);
                }
            }
        }
        try {
            if (msgReceivedM.getBoolean("booleanValue") != this.booleanValue) {
                TestUtil.logErr("Fail: invalid boolean returned: " + msgReceivedM.getBoolean("booleanValue"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getByte("byteValue") != this.byteValue) {
                TestUtil.logErr("Fail: invalid byte returned: " + msgReceivedM.getByte("byteValue"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            b = msgReceivedM.getBytes("bytesValue");
            for (int i = 0; i < b.length; ++i) {
                if (b[i] == this.bytesValue[i]) continue;
                TestUtil.logErr("Fail: byte array " + i + " not valid: " + b[i]);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            b = msgReceivedM.getBytes("bytesValue2");
            if (b[0] != this.bytesValue[0]) {
                TestUtil.logErr("Fail: byte array not valid " + b[0]);
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getChar("charValue") != this.charValue) {
                TestUtil.logErr("Fail: invalid char returned: " + msgReceivedM.getChar("charValue"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getDouble("doubleValue") != this.doubleValue) {
                TestUtil.logErr("Fail: invalid double returned: " + msgReceivedM.getDouble("doubleValue"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getFloat("floatValue") != this.floatValue) {
                TestUtil.logErr("Fail: invalid float returned");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getInt("intValue") != this.intValue) {
                TestUtil.logErr("Fail: invalid int returned");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getLong("longValue") != this.longValue) {
                TestUtil.logErr("Fail: invalid long returned");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (!msgReceivedM.getObject("nInteger").toString().equals(this.nInteger.toString())) {
                TestUtil.logErr("Fail: invalid object returned");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getShort("shortValue") != this.shortValue) {
                TestUtil.logErr("Fail: invalid short returned");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (!msgReceivedM.getString("stringValue").equals(this.stringValue)) {
                TestUtil.logErr("Fail: invalid string returned");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        try {
            if (msgReceivedM.getString("nullTest") != null) {
                TestUtil.logErr("Fail:  null not returned from getString: " + msgReceivedM.getString("nullTest"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Fail: unexpected exception " + e.getClass().getName() + " was returned", e);
            pass = false;
        }
        return pass;
    }

    @Override
    public ArrayList sendFullStreamMessage_Q(String testName) {
        return this.sendStreamMessage_Q(testName, false, 2);
    }

    @Override
    public ArrayList sendStreamMessage_Q(String testName, boolean setDest) {
        return this.sendStreamMessage_Q(testName, setDest, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendStreamMessage_Q(String testName, boolean setDest, int mode) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.setup_Q();
            StreamMessage messageSent = null;
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueSender");
            QueueSender qsender = qsess.createSender(this.queue);
            qsender.setPriority(this.priority);
            qsender.setTimeToLive(this.forever);
            if (mode != 2) {
                qsender.setDeliveryMode(mode);
            }
            TestUtil.logMsg("Creating 1 StreamMessage");
            messageSent = qsess.createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSent.setJMSCorrelationID(this.jmsCorrelationID);
            messageSent.setJMSType(this.type);
            if (setDest) {
                messageSent.setJMSReplyTo((Destination)this.queue);
            }
            messageSent.writeBytes(this.byteValues2, 0, this.byteValues.length);
            messageSent.writeBoolean(this.booleanValue);
            messageSent.writeByte(this.byteValue);
            messageSent.writeBytes(this.byteValues);
            messageSent.writeChar(this.charValue);
            messageSent.writeDouble(this.doubleValue);
            messageSent.writeFloat(this.floatValue);
            messageSent.writeInt(this.intValue);
            messageSent.writeLong(this.longValue);
            messageSent.writeObject((Object)this.sTesting);
            messageSent.writeShort(this.shortValue);
            messageSent.writeString(this.stringValue);
            messageSent.writeObject(null);
            TestUtil.logTrace("Sending a StreamMessage ...");
            timeBeforeSend = System.currentTimeMillis();
            qsender.send((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)messageSent, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendFullStreamMessage_Q", e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing QueueConnection in sendFullStreamMessage_Q");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing QueueConnection in sendFullStreamMessage_Q", ce);
                }
            }
        }
        return valueAtSend;
    }

    @Override
    public boolean verifyFullStreamMessage() {
        TestUtil.logTrace("In verifyFullStreamMessage");
        boolean pass = true;
        StreamMessage messageReceived = null;
        try {
            this.setup_Q();
            this.qconn.start();
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueReceiver");
            QueueReceiver qreceiver = qsess.createReceiver(this.queue);
            messageReceived = (StreamMessage)qreceiver.receive(this.timeout);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in verifyFullStreamMessage: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in verifyFullStreamMessage");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in verifyFullStreamMessage", ce);
                }
            }
        }
        try {
            int nCount;
            do {
                nCount = messageReceived.readBytes(this.byteValuesReturned2);
                TestUtil.logTrace("nCount is " + nCount);
                if (nCount == -1) continue;
                for (int i = 0; i < this.byteValuesReturned2.length; ++i) {
                    if (this.byteValuesReturned2[i] == this.byteValues2[i]) continue;
                    TestUtil.logErr("Fail: byte[] " + i + " is not valid =" + this.byteValuesReturned2[i]);
                    pass = false;
                }
            } while (nCount >= this.byteValuesReturned2.length);
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readBoolean() != this.booleanValue) {
                TestUtil.logErr("Fail: boolean not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readByte() != this.byteValue) {
                TestUtil.logErr("Fail: Byte not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            int nCount;
            do {
                nCount = messageReceived.readBytes(this.byteValuesReturned);
                TestUtil.logTrace("nCount is " + nCount);
                if (nCount == -1) continue;
                for (int i = 0; i < this.byteValuesReturned.length; ++i) {
                    if (this.byteValuesReturned[i] == this.byteValues[i]) continue;
                    TestUtil.logErr("Fail: byte[] " + i + " is not valid");
                    pass = false;
                }
            } while (nCount >= this.byteValuesReturned.length);
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readChar() != this.charValue) {
                TestUtil.logErr("Fail: char not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readDouble() != this.doubleValue) {
                TestUtil.logErr("Fail: double not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readFloat() != this.floatValue) {
                TestUtil.logErr("Fail: float not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readInt() != this.intValue) {
                TestUtil.logErr("Fail: int not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readLong() != this.longValue) {
                TestUtil.logErr("Fail: long not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (!messageReceived.readObject().equals(this.sTesting)) {
                TestUtil.logErr("Fail: object not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readShort() != this.shortValue) {
                TestUtil.logErr("Fail: short not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (!messageReceived.readString().equals(this.stringValue)) {
                TestUtil.logErr("Fail: string not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        try {
            if (messageReceived.readObject() != null) {
                TestUtil.logErr("Fail: object not returned as expected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr("Error: exception was thrown in verifyFullStreamMessage: ", e);
            pass = false;
        }
        return pass;
    }

    @Override
    public ArrayList sendObjectMessage_Q(String testName) {
        return this.sendObjectMessage_Q(testName, false, 2);
    }

    @Override
    public ArrayList sendObjectMessage_Q(String testName, boolean setDest) {
        return this.sendObjectMessage_Q(testName, setDest, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList sendObjectMessage_Q(String testName, boolean setDest, int mode) {
        ArrayList valueAtSend = null;
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            this.setup_Q();
            ObjectMessage messageSent = null;
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueSender");
            QueueSender qsender = qsess.createSender(this.queue);
            qsender.setPriority(this.priority);
            qsender.setTimeToLive(this.forever);
            if (mode != 2) {
                qsender.setDeliveryMode(mode);
            }
            TestUtil.logMsg("Creating 1 ObjectMessage");
            messageSent = qsess.createObjectMessage();
            messageSent.setObject((Serializable)((Object)String.valueOf("HeaderIDTest for ObjectMessage")));
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSent.setJMSCorrelationID(this.jmsCorrelationID);
            messageSent.setJMSType(this.type);
            if (setDest) {
                messageSent.setJMSReplyTo((Destination)this.queue);
            }
            TestUtil.logTrace("Sending an ObjectMessage...");
            timeBeforeSend = System.currentTimeMillis();
            qsender.send((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            valueAtSend = this.logPropertyAtSend((Message)this.messageSentB, timeBeforeSend, timeAfterSend);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to send a Message in sendObjectMessage_Q", e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing QueueConnection in sendObjectMessage_Q");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing QueueConnection in sendObjectMessage_Q", ce);
                }
            }
        }
        return valueAtSend;
    }

    public ObjectMessage receiveObjectMessage_Q() {
        ObjectMessage receivedM = null;
        try {
            this.setup_Q();
            this.qconn.start();
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueReceiver");
            QueueReceiver qreceiver = qsess.createReceiver(this.queue);
            receivedM = (ObjectMessage)qreceiver.receive(this.timeout);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in receiveObjectMessage_Q: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in receiveObjectMessage_Q");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in receiveObjectMessage_Q" + ce.getMessage(), ce);
                }
            }
        }
        return receivedM;
    }

    public Message receiveMessage_Q() {
        Message receivedM = null;
        try {
            this.setup_Q();
            this.qconn.start();
            TestUtil.logTrace("Creating QueueSession");
            QueueSession qsess = this.qconn.createQueueSession(true, 1);
            TestUtil.logTrace("Creating QueueReceiver");
            QueueReceiver qreceiver = qsess.createReceiver(this.queue);
            receivedM = qreceiver.receive(this.timeout);
        }
        catch (Exception e) {
            TestUtil.logErr("Failed to receive a message in receiveMessage_Q: ", e);
            throw new EJBException(e);
        }
        finally {
            if (this.qconn != null) {
                try {
                    TestUtil.logTrace("Closing Connection in receiveMessage_Q");
                    this.qconn.close();
                }
                catch (Exception ce) {
                    TestUtil.logErr("Error closing conn in receiveMessage_Q" + ce.getMessage(), ce);
                }
            }
        }
        return receivedM;
    }

    @Override
    public String getMessageID() {
        Message msg = this.receiveMessage_Q();
        String id = null;
        try {
            id = msg.getJMSMessageID();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSMessageID in getMessageID: ", e);
        }
        return id;
    }

    @Override
    public long getTimeStamp() {
        Message msg = this.receiveMessage_Q();
        long JMSTimestamp = 0L;
        try {
            JMSTimestamp = msg.getJMSTimestamp();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSTimestamp in getTimeStamp: ", e);
        }
        return JMSTimestamp;
    }

    @Override
    public String getCorrelationID() {
        String jmsCorrelationID = null;
        Message msg = this.receiveMessage_Q();
        try {
            jmsCorrelationID = msg.getJMSCorrelationID();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSCorrelationID in getCorrelationID: ", e);
        }
        return jmsCorrelationID;
    }

    @Override
    public String getReplyTo() {
        Message msg = this.receiveMessage_Q();
        Destination replyto = null;
        try {
            replyto = msg.getJMSReplyTo();
            if (replyto != null) {
                return ((Queue)replyto).getQueueName();
            }
            return null;
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSReplyTo in getReplyTo: ", e);
            return null;
        }
    }

    @Override
    public String getType() {
        Message msg = this.receiveMessage_Q();
        String jmsType = null;
        try {
            jmsType = msg.getJMSType();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSType in getType: ", e);
        }
        return jmsType;
    }

    @Override
    public int getPriority() {
        Message msg = this.receiveMessage_Q();
        int jmsPriority = 0;
        try {
            jmsPriority = msg.getJMSPriority();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSPriority in getPriority: ", e);
        }
        return jmsPriority;
    }

    @Override
    public long getExpiration() {
        Message msg = this.receiveMessage_Q();
        long jmsExpiration = 0L;
        try {
            jmsExpiration = msg.getJMSExpiration();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSExpiration in getExpiration: ", e);
        }
        return jmsExpiration;
    }

    @Override
    public String getDestination_1() {
        String tmp = null;
        try {
            TestUtil.logTrace("Getting Destination java:comp/env/jms/MY_QUEUE");
            Destination dest = (Destination)this.nctx.lookup(TESTQUEUENAME);
            tmp = ((Queue)dest).getQueueName();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception in getDestination_1: ", e);
        }
        return tmp;
    }

    @Override
    public String getDestination() {
        Message msg = this.receiveMessage_Q();
        String tmp = null;
        try {
            tmp = ((Queue)msg.getJMSDestination()).getQueueName();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSDestination in getDestination: ", e);
        }
        return tmp;
    }

    @Override
    public int getDeliveryMode() {
        Message msg = this.receiveMessage_Q();
        int jmsMode = 0;
        try {
            jmsMode = msg.getJMSDeliveryMode();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getJMSDeliveryMode in getDeliveryMode: ", e);
        }
        return jmsMode;
    }

    @Override
    public String getText() {
        Message msg = this.receiveMessage_Q();
        String text = null;
        try {
            text = ((TextMessage)msg).getText();
        }
        catch (Exception e) {
            TestUtil.logErr("Exception calling getText in getText: ", e);
        }
        return text;
    }
}

