/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.TestWorkManager;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.UnavailableException;
import jakarta.resource.spi.XATerminator;
import jakarta.resource.spi.work.HintsContext;
import jakarta.resource.spi.work.SecurityContext;
import jakarta.resource.spi.work.TransactionContext;
import jakarta.resource.spi.work.WorkManager;
import jakarta.transaction.TransactionSynchronizationRegistry;
import java.util.Timer;
import javax.transaction.xa.Xid;

public class TestBootstrapContext {
    private BootstrapContext bsc;
    private WorkManager wrkmgr;
    private Timer timer1;
    private Timer timer2;

    public TestBootstrapContext(BootstrapContext bsc) {
        this.bsc = bsc;
    }

    public void runTests() {
        Debug.trace("Inside TestBootStrapContext.runTests");
        this.testTimer();
        this.testXATerminator();
        this.testIsContextSupported();
        this.testTransactionSynchronizationRegistry();
        this.testTSRLookup();
    }

    public void testTSRLookup() {
        try {
            TSNamingContext ncxt = new TSNamingContext();
            String tsrStr = "java:comp/TransactionSynchronizationRegistry";
            Object obj = ncxt.lookup(tsrStr);
            if (obj != null) {
                ConnectorStatus.getConnectorStatus().logState("TSR Lookup Successful");
                Debug.trace("TSR Lookup Successful");
            } else {
                Debug.trace("TSR Null");
            }
        }
        catch (Throwable ex) {
            Debug.trace("Exception when calling testTSRLookup()");
            Debug.trace("This is okay if JNDI lookup of tsr is not supported in standalone JCA");
            ex.getMessage();
        }
    }

    public void testTransactionSynchronizationRegistry() {
        try {
            TransactionSynchronizationRegistry tr = this.bsc.getTransactionSynchronizationRegistry();
            if (tr != null) {
                String str = "getTransactionSynchronizationRegistry supported by Server";
                Debug.trace(str);
                ConnectorStatus.getConnectorStatus().logState(str);
            } else {
                Debug.trace("getTransactionSynchronizationRegistry not supported by Server.");
            }
        }
        catch (Throwable ex) {
            Debug.trace("Exception when calling getTransactionSynchronizationRegistry()");
            ex.getMessage();
        }
    }

    private void testTimer() {
        try {
            this.timer1 = this.bsc.createTimer();
            this.timer2 = this.bsc.createTimer();
            Debug.trace("Inside TestBootStrapContext.testTimer()");
            if (this.timer1 == null || this.timer2 == null) {
                ConnectorStatus.getConnectorStatus().logState("Timer is Null");
            } else if (this.timer1.equals(this.timer2)) {
                ConnectorStatus.getConnectorStatus().logState("Shared Timer Provided by BootstrapContext");
                Debug.trace("Timer is shared or returned the same instance");
            } else {
                ConnectorStatus.getConnectorStatus().logState("New Timer Provided by BootstrapContext");
                Debug.trace("New Timer Provided by BootstrapContext");
            }
        }
        catch (UnavailableException ex) {
            ConnectorStatus.getConnectorStatus().logState("Timer UnavailableException");
        }
        catch (UnsupportedOperationException uex) {
            ConnectorStatus.getConnectorStatus().logState("Timer UnsupportedOperationException");
        }
    }

    private void testXATerminator() {
        try {
            XATerminator xt = this.bsc.getXATerminator();
            this.wrkmgr = this.bsc.getWorkManager();
            TestWorkManager twm = new TestWorkManager(this.bsc);
            Xid myid = twm.getXid();
            Xid nestxid = twm.getNestXid();
            if (xt != null) {
                ConnectorStatus.getConnectorStatus().logState("XATerminator is not null");
                Debug.trace("TestBootStrapContext.testXATerminator XID is " + myid.getFormatId());
                Debug.trace("TestBootStrapContext.testXATerminator XID is " + nestxid.getFormatId());
                xt.commit(myid, true);
                xt.commit(nestxid, true);
                ConnectorStatus.getConnectorStatus().logState("Xid Committed");
                Debug.trace("XATerminator committed xid");
            }
        }
        catch (Throwable ex) {
            ex.getMessage();
        }
    }

    private void testIsContextSupported() {
        try {
            Class<HintsContext> hic;
            boolean b3;
            Class<SecurityContext> sic;
            boolean b2;
            Class<TransactionContext> tic = TransactionContext.class;
            boolean b1 = this.bsc.isContextSupported(tic);
            if (b1) {
                Debug.trace("TransactionContext supported by Server.");
                ConnectorStatus.getConnectorStatus().logState("TransactionContext supported by Server.");
            }
            if (b2 = this.bsc.isContextSupported(sic = SecurityContext.class)) {
                Debug.trace("SecurityContext supported by Server.");
                ConnectorStatus.getConnectorStatus().logState("SecurityContext supported by Server.");
            }
            if (b3 = this.bsc.isContextSupported(hic = HintsContext.class)) {
                ConnectorStatus.getConnectorStatus().logState("HintsContext supported by Server.");
            }
        }
        catch (Throwable ex) {
            ex.getMessage();
        }
    }
}

