/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.jaxrs21.platform.providers.jsonb;

import jakarta.json.JsonNumber;
import jakarta.json.JsonString;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;

@Path(value="resource")
public class Resource {
    public static final String MESSAGE = "This.is.some.message";
    public static final String URL = "http://tck.cts.oracle.com:12345";

    @Path(value="tostring")
    @GET
    @Produces(value={"application/json"})
    public String toString() {
        return MESSAGE;
    }

    @Path(value="tochar")
    @GET
    @Produces(value={"application/json"})
    public Character toCharacter() {
        return Character.valueOf(MESSAGE.charAt(0));
    }

    @Path(value="tobyte")
    @GET
    @Produces(value={"application/json"})
    public Byte toByte() {
        return (byte)127;
    }

    @Path(value="toshort")
    @GET
    @Produces(value={"application/json"})
    public Short toShort() {
        return (short)Short.MAX_VALUE;
    }

    @Path(value="toint")
    @GET
    @Produces(value={"application/json"})
    public Integer toInteger() {
        return Integer.MAX_VALUE;
    }

    @Path(value="tolong")
    @GET
    @Produces(value={"application/json"})
    public Long toLong() {
        return Long.MAX_VALUE;
    }

    @Path(value="todouble")
    @GET
    @Produces(value={"application/json"})
    public Double toDouble() {
        return Double.MAX_VALUE;
    }

    @Path(value="toboolean")
    @GET
    @Produces(value={"application/json"})
    public Boolean toBoolean() {
        return Boolean.TRUE;
    }

    @Path(value="tonumber")
    @GET
    @Produces(value={"application/json"})
    public Number toNumber() {
        return BigDecimal.valueOf(Long.MAX_VALUE);
    }

    @Path(value="tobiginteger")
    @GET
    @Produces(value={"application/json"})
    public BigInteger toBigInteger() {
        return BigInteger.valueOf(Long.MAX_VALUE);
    }

    @Path(value="touri")
    @GET
    @Produces(value={"application/json"})
    public URI toURI() throws URISyntaxException {
        return new URI(URL);
    }

    @Path(value="tourl")
    @GET
    @Produces(value={"application/json"})
    public URL toURL() throws MalformedURLException {
        return new URL(URL);
    }

    @Path(value="tooptional")
    @GET
    @Produces(value={"application/json"})
    public Optional<String> toOptional() {
        return Optional.of(MESSAGE);
    }

    @Path(value="tooptionalint")
    @GET
    @Produces(value={"application/json"})
    public OptionalInt toOptionalInt() {
        return OptionalInt.of(Integer.MIN_VALUE);
    }

    @Path(value="tooptionallong")
    @GET
    @Produces(value={"application/json"})
    public OptionalLong toOptionalLong() {
        return OptionalLong.of(Long.MIN_VALUE);
    }

    @Path(value="tooptionaldouble")
    @GET
    @Produces(value={"application/json"})
    public OptionalDouble toOptionalDouble() {
        return OptionalDouble.of(Double.MIN_VALUE);
    }

    @Path(value="tocalendar")
    @GET
    @Produces(value={"application/json"})
    public Calendar toCalendar() {
        Calendar c = Calendar.getInstance(TimeZone.getTimeZone(ZoneId.of("Z")), Locale.US);
        c.set(1999, 11, 31);
        return c;
    }

    @Path(value="totimezone")
    @GET
    @Produces(value={"application/json"})
    public TimeZone toTimeZone() {
        TimeZone tz = TimeZone.getTimeZone(ZoneId.of("Z"));
        return tz;
    }

    @Path(value="fromstring")
    @POST
    @Produces(value={"application/json"})
    public String fromObject(JsonString string) {
        return string.getString();
    }

    @Path(value="fromnumber")
    @POST
    @Produces(value={"application/json"})
    public String fromNumber(JsonNumber number) {
        return number.bigDecimalValue().toString();
    }
}

