/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.ee.packaging.ejb.descriptor;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import ee.jakarta.tck.persistence.ee.packaging.ejb.descriptor.A;
import ee.jakarta.tck.persistence.ee.packaging.ejb.descriptor.B;
import ee.jakarta.tck.persistence.ee.packaging.ejb.descriptor.Stateless3IF;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import java.util.Properties;

@Stateless(name="Stateless3Bean")
@TransactionManagement(value=TransactionManagementType.CONTAINER)
public class Stateless3Bean
implements Stateless3IF {
    private EntityManagerFactory emf;
    private EntityManager entityManager;
    public SessionContext sessionContext;
    private static final B[] bRef = new B[5];
    private static final A[] aRef = new A[5];

    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PostConstruct
    public void prepareEnvironment() {
        try {
            TestUtil.logTrace((String)"In PostContruct");
            if (this.emf == null) {
                this.emf = (EntityManagerFactory)this.sessionContext.lookup("persistence/MyPersistenceUnit");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)" In PostConstruct: Unexpected Exception caught", (Throwable)e);
        }
    }

    public void createTestData() {
        TestUtil.logTrace((String)"createTestData");
        try {
            TestUtil.logTrace((String)"joinTransaction");
            this.entityManager.joinTransaction();
            TestUtil.logTrace((String)"Create 2 A Entities");
            Stateless3Bean.aRef[0] = new A("3", "herB", 3);
            Stateless3Bean.aRef[1] = new A("4", "hisB", 4);
            TestUtil.logTrace((String)"Create 2 B Entities");
            Stateless3Bean.bRef[0] = new B("1", "myB", 1, aRef[0]);
            Stateless3Bean.bRef[1] = new B("2", "yourB", 2, aRef[1]);
            TestUtil.logTrace((String)"Start to persist Bees ");
            for (B b : bRef) {
                if (b == null) continue;
                this.entityManager.persist((Object)b);
                TestUtil.logTrace((String)("persisted B " + b));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Unexpected while creating test data:" + e));
        }
    }

    @Override
    public void removeTestData() {
        TestUtil.logTrace((String)"stateless3Bean removeTestData");
        try {
            if (this.entityManager == null || !this.entityManager.isOpen()) {
                this.entityManager = this.emf.createEntityManager();
            }
            this.entityManager.createNativeQuery("DELETE FROM BEJB_1X1_BI_BTOB").executeUpdate();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception caught while cleaning up:", (Throwable)e);
        }
        finally {
            if (this.entityManager.isOpen()) {
                this.entityManager.close();
            }
        }
        TestUtil.logTrace((String)"Clearing cache");
        this.emf.getCache().evictAll();
        TestUtil.logTrace((String)"cleanup complete");
    }

    public void init(Properties p) {
        TestUtil.logTrace((String)"init");
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }

    @Override
    public boolean test5() {
        TestUtil.logTrace((String)"Begin test5");
        boolean pass = false;
        try {
            if (this.emf != null) {
                TestUtil.logTrace((String)"DEBUG: EMF IS NOT null");
                this.entityManager = this.emf.createEntityManager();
                if (null != this.entityManager) {
                    TestUtil.logTrace((String)"ENTITYMANAGER IS NOT NULL");
                    this.createTestData();
                    B anotherB = (B)this.entityManager.find(B.class, (Object)"1");
                    if (anotherB != null) {
                        TestUtil.logTrace((String)"anotherB found");
                        pass = true;
                    }
                } else {
                    TestUtil.logErr((String)"ENTITYMANAGER IS NULL");
                }
            } else {
                TestUtil.logErr((String)"EMF is null");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception :", (Throwable)e);
        }
        finally {
            try {
                if (this.entityManager != null && this.entityManager.isOpen()) {
                    this.entityManager.close();
                }
            }
            catch (IllegalStateException ise) {
                TestUtil.logErr((String)"Unexpected Exception :", (Throwable)ise);
            }
        }
        return pass;
    }
}

