/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.timer.timerconfig;

import com.sun.ts.tests.ejb30.timer.common.ClientBase;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import com.sun.ts.tests.ejb30.timer.timerconfig.TimerConfigIF;
import jakarta.ejb.EJB;
import jakarta.ejb.ScheduleExpression;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerConfig;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;

public class Client
extends ClientBase {
    @EJB(beanName="TimerConfigBean")
    protected TimerConfigIF timerConfigBean;

    @Override
    public void setup(String[] args, Properties p) {
        super.setup(args, p);
        this.timerConfigBean.cancelAllTimers();
    }

    public void isPersistent() {
        Object name = this.getTestName();
        ScheduleExpression exp = new ScheduleExpression();
        exp = exp.hour("*").minute("*").second("*/2");
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo((String)name));
        Timer timerPersistent = this.timerConfigBean.createTimer(exp, timerConfig);
        this.assertEquals(null, true, this.timerConfigBean.isPersistent(timerPersistent));
        this.passIfRecurringTimeout((String)name, new long[0]);
        this.timerConfigBean.cancelTimer(timerPersistent);
        name = (String)name + "-nonpersistent";
        timerConfig.setInfo((Serializable)new TimerInfo((String)name));
        timerConfig.setPersistent(false);
        Timer timerNonPersistent = this.timerConfigBean.createTimer(exp, timerConfig);
        this.assertEquals(null, false, this.timerConfigBean.isPersistent(timerNonPersistent));
        this.passIfRecurringTimeout((String)name, new long[0]);
        this.timerConfigBean.cancelTimer(timerNonPersistent);
    }

    public void gettersSetters() {
        this.timerConfigBean.gettersSetters(this.getReasonBuffer());
    }

    public void illegalArgumentException() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        this.timerConfigBean.illegalArgumentException(this.getReasonBuffer(), timerConfig);
    }

    public void resetTimerConfig() {
        this.timerConfigBean.resetTimerConfig(this.getTestName(), this.getReasonBuffer());
    }

    public void createTimerWithLong() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        this.timerConfigBean.createTimer(100L, timerConfig);
        this.passIfTimeout(new long[0]);
    }

    public void createTimerWithLongRecurring() {
        try {
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
            this.timerConfigBean.createTimer(100L, 100L, timerConfig);
            this.passIfRecurringTimeout(new long[0]);
        }
        finally {
            this.timerConfigBean.cancelAllTimers();
        }
    }

    public void createTimerWithDate() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        Date expirationDate = TimerUtil.getCurrentDatePlus(13, 1);
        this.timerConfigBean.createTimer(expirationDate, timerConfig);
        this.passIfTimeout(new long[0]);
    }

    public void createTimerWithDateRecurring() {
        try {
            TimerConfig timerConfig = new TimerConfig();
            timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
            Date expirationDate = TimerUtil.getCurrentDatePlus(13, 1);
            this.timerConfigBean.createTimer(expirationDate, 100L, timerConfig);
            this.passIfRecurringTimeout(new long[0]);
        }
        finally {
            this.timerConfigBean.cancelAllTimers();
        }
    }

    public void createTimerWithSchedule() {
        TimerConfig timerConfig = new TimerConfig();
        timerConfig.setInfo((Serializable)new TimerInfo(this.getTestName()));
        Calendar cal = Calendar.getInstance();
        cal.add(13, 1);
        this.timerConfigBean.createTimer(TimerUtil.getPreciseScheduleExpression(cal), timerConfig);
        this.passIfTimeout(new long[0]);
    }
}

