/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.allowed;

import com.sun.ts.tests.ejb30.common.allowed.Constants;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Timer;
import jakarta.ejb.TimerService;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import javax.naming.InitialContext;

public class Operations
implements Constants {
    private static Operations instance = new Operations();

    protected Operations() {
    }

    public static Operations getInstance() {
        return instance;
    }

    public void tryRollback(SessionContext sctx) throws TestFailedException {
        try {
            sctx.getRollbackOnly();
            throw new TestFailedException("Expecting IllegalStateException from getRollbackOnly(), but got no exception.");
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception e) {
            throw new TestFailedException("Expecting IllegalStateException from getRollbackOnly(),  but got " + e);
        }
    }

    public void runRollbackOnly(SessionContext sctx, Properties results) {
        this.getSetRollbackOnly(sctx, results);
    }

    public void getSetRollbackOnly(SessionContext sctx, Properties results) {
        try {
            sctx.getRollbackOnly();
            results.setProperty("getRollbackOnly", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getRollbackOnly", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getRollbackOnly", e.toString());
        }
        try {
            sctx.setRollbackOnly();
            results.setProperty("setRollbackOnly", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("setRollbackOnly", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("setRollbackOnly", e.toString());
        }
    }

    public void runUserTransaction(SessionContext sctx, Properties results) {
        try {
            UserTransaction ut = sctx.getUserTransaction();
            results.setProperty("UserTransaction", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("UserTransaction", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("UserTransaction", e.toString());
        }
        try {
            sctx.getUserTransaction().begin();
            results.setProperty("UserTransaction_Methods_Test1", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("UserTransaction_Methods_Test1", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("UserTransaction_Methods_Test1", e.toString());
        }
        try {
            sctx.getUserTransaction().commit();
            results.setProperty("UserTransaction_Methods_Test2", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("UserTransaction_Methods_Test2", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("UserTransaction_Methods_Test2", e.toString());
        }
        try {
            sctx.getUserTransaction().getStatus();
            results.setProperty("UserTransaction_Methods_Test3", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("UserTransaction_Methods_Test3", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("UserTransaction_Methods_Test3", e.toString());
        }
        try {
            sctx.getUserTransaction().rollback();
            results.setProperty("UserTransaction_Methods_Test4", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("UserTransaction_Methods_Test4", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("UserTransaction_Methods_Test4", e.toString());
        }
        try {
            sctx.getUserTransaction().setRollbackOnly();
            results.setProperty("UserTransaction_Methods_Test5", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("UserTransaction_Methods_Test5", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("UserTransaction_Methods_Test5", e.toString());
        }
        try {
            sctx.getUserTransaction().setTransactionTimeout(0);
            results.setProperty("UserTransaction_Methods_Test6", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("UserTransaction_Methods_Test6", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("UserTransaction_Methods_Test6", e.toString());
        }
    }

    public void runTimers(SessionContext sctx, Properties results) {
        Date d;
        try {
            sctx.getTimerService();
            results.setProperty("getTimerService", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getTimerService", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getTimerService", e.toString());
        }
        try {
            TimerService timesrv = sctx.getTimerService();
            Timer tt = timesrv.createTimer(10000L, (Serializable)((Object)"test1"));
            tt.cancel();
            results.setProperty("TimerService_Methods_Test1", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("TimerService_Methods_Test1", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("TimerService_Methods_Test1", e.toString());
        }
        try {
            TimerService timesrv2 = sctx.getTimerService();
            Timer t2 = timesrv2.createTimer(10000L, 10000L, (Serializable)((Object)"test2"));
            t2.cancel();
            results.setProperty("TimerService_Methods_Test2", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("TimerService_Methods_Test2", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("TimerService_Methods_Test2", e.toString());
        }
        try {
            long expiration = System.currentTimeMillis() + 900000L;
            d = new Date(expiration);
            TimerService timesrv3 = sctx.getTimerService();
            Timer t3 = timesrv3.createTimer(d, (Serializable)((Object)"test3"));
            t3.cancel();
            results.setProperty("TimerService_Methods_Test3", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("TimerService_Methods_Test3", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("TimerService_Methods_Test3", e.toString());
        }
        try {
            long expiration = System.currentTimeMillis() + 900000L;
            d = new Date(expiration);
            TimerService timesrv4 = sctx.getTimerService();
            Timer t4 = timesrv4.createTimer(d, 10000L, (Serializable)((Object)"test4"));
            t4.cancel();
            results.setProperty("TimerService_Methods_Test4", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("TimerService_Methods_Test4", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("TimerService_Methods_Test4", e.toString());
        }
        try {
            TimerService ts = sctx.getTimerService();
            Collection ccol = ts.getTimers();
            results.setProperty("TimerService_Methods_Test5", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("TimerService_Methods_Test5", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("TimerService_Methods_Test5", e.toString());
        }
        try {
            TimerService timesrv6 = sctx.getTimerService();
            Timer t6 = timesrv6.createTimer(10000L, (Serializable)((Object)"test6"));
            t6.getHandle();
            t6.cancel();
            results.setProperty("TimerService_Methods_Test6", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("TimerService_Methods_Test6", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("TimerService_Methods_Test6", e.toString());
        }
        try {
            TimerService timesrv7 = sctx.getTimerService();
            Timer t7 = timesrv7.createTimer(10000L, (Serializable)((Object)"test7"));
            t7.cancel();
            results.setProperty("TimerService_Methods_Test7", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("TimerService_Methods_Test7", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("TimerService_Methods_Test7", e.toString());
        }
    }

    public void runGetEJBHome(SessionContext sctx, Properties results) {
        try {
            sctx.getEJBHome();
            results.setProperty("getEJBHome", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getEJBHome", "disallowed");
        }
        catch (Exception e) {
            e.printStackTrace();
            results.setProperty("getEJBHome", e.toString());
        }
    }

    public void runGetCallerPrincipal(SessionContext sctx, Properties results) {
        try {
            sctx.getCallerPrincipal();
            results.setProperty("getCallerPrincipal", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getCallerPrincipal", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getCallerPrincipal", e.toString());
        }
    }

    public void runIsCallerInRole(SessionContext sctx, Properties results) {
        try {
            sctx.isCallerInRole("Administrator");
            results.setProperty("isCallerInRole", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("isCallerInRole", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("isCallerInRole", e.toString());
        }
    }

    public void runGetEJBObject(SessionContext sctx, Properties results) {
        try {
            sctx.getEJBObject();
            results.setProperty("getEJBObject", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getEJBObject", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getEJBObject", e.toString());
        }
    }

    public void runJndiAccess(SessionContext sctx, Properties results) {
        try {
            InitialContext nctx = new InitialContext();
            boolean myBoolean = (Boolean)nctx.lookup("java:comp/env/myBoolean");
            if (myBoolean) {
                results.setProperty("JNDI_Access", "allowed");
            } else {
                results.setProperty("JNDI_Access", "jndi lookup is ok but returns unexpected value " + myBoolean);
            }
        }
        catch (IllegalStateException e) {
            results.setProperty("JNDI_Access", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("JNDI_Access", e.toString());
        }
    }

    public void runEJBContextLookup(SessionContext sctx, Properties results) {
        try {
            boolean myBoolean = (Boolean)sctx.lookup("myBoolean");
            if (myBoolean) {
                results.setProperty("EJBContext_lookup", "allowed");
            } else {
                results.setProperty("EJBContext_lookup", "lookup is ok but returns unexpected value " + myBoolean);
            }
        }
        catch (IllegalStateException e) {
            results.setProperty("EJBContext_lookup", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("EJBContext_lookup", e.toString());
        }
    }

    public void runGetEJBLocalHome(SessionContext sctx, Properties results) {
        try {
            sctx.getEJBLocalHome();
            results.setProperty("getEJBLocalHome", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getEJBLocalHome", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getEJBLocalHome", e.toString());
        }
    }

    public void runGetEJBLocalObject(SessionContext sctx, Properties results) {
        try {
            sctx.getEJBLocalObject();
            results.setProperty("getEJBLocalObject", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getEJBLocalObject", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getEJBLocalObject", e.toString());
        }
    }

    public void runGetBusinessObject(SessionContext sctx, Properties results, Class intf) {
        try {
            sctx.getBusinessObject(intf);
            results.setProperty("getBusinessObject", "allowed");
        }
        catch (IllegalStateException e) {
            results.setProperty("getBusinessObject", "disallowed");
        }
        catch (Exception e) {
            results.setProperty("getBusinessObject", e.toString());
        }
    }

    public Properties run2(SessionContext sctx, Class intf) {
        Properties results = this.run(sctx);
        this.runGetBusinessObject(sctx, results, intf);
        return results;
    }

    public Properties run(SessionContext sctx) {
        TLogger.log("about to run operations...");
        Properties results = new Properties();
        this.runGetEJBHome(sctx, results);
        this.runGetCallerPrincipal(sctx, results);
        this.runIsCallerInRole(sctx, results);
        this.runGetEJBObject(sctx, results);
        this.runJndiAccess(sctx, results);
        this.runEJBContextLookup(sctx, results);
        this.runUserTransaction(sctx, results);
        this.runGetEJBLocalHome(sctx, results);
        this.runGetEJBLocalObject(sctx, results);
        this.runTimers(sctx, results);
        this.runRollbackOnly(sctx, results);
        return results;
    }
}

