/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.selenium;

import java.time.Duration;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jboss.cdi.tck.selenium.ExtendedWebDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebPage {
    public static final Duration STD_TIMEOUT = Duration.ofMillis(8000L);
    public static final Duration LONG_TIMEOUT = Duration.ofMillis(16000L);
    protected ExtendedWebDriver webDriver;

    public WebPage(ExtendedWebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public ExtendedWebDriver getWebDriver() {
        return this.webDriver;
    }

    public void setWebDriver(ExtendedWebDriver webDriver) {
        this.webDriver = webDriver;
    }

    public void waitForBackgroundJavascript(Duration timeout) {
        this.waitForBackgroundJavascript(timeout, Duration.ZERO);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForBackgroundJavascript(Duration timeout, Duration delayAfterExcecution) {
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            WebDriverWait wait = new WebDriverWait((WebDriver)this.webDriver, timeout);
            double rand = Math.random();
            String identifier = "__insert__:" + rand;
            this.webDriver.manage().timeouts().scriptTimeout(timeout);
            try {
                this.webDriver.getJSExecutor().executeAsyncScript("let [resolve] = arguments; setTimeout(function() { var insert__ = document.createElement('div');insert__.id = '" + identifier + "';insert__.innerHTML = 'done';document.body.append(insert__); resolve()}, 50);", new Object[0]);
                wait.until((Function)ExpectedConditions.numberOfElementsToBeMoreThan((By)By.id((String)identifier), (Integer)0));
                if (!delayAfterExcecution.isZero()) {
                    this.wait(delayAfterExcecution);
                }
            }
            finally {
                this.webDriver.getJSExecutor().executeScript("document.body.removeChild(document.getElementById('" + identifier + "'));", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void waitForCondition(Function<? super WebDriver, V> isTrue, Duration timeout) {
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            WebDriverWait wait = new WebDriverWait((WebDriver)this.webDriver, timeout);
            wait.until(isTrue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> void waitForCondition(Function<? super WebDriver, V> isTrue) {
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            WebDriverWait wait = new WebDriverWait((WebDriver)this.webDriver, LONG_TIMEOUT);
            wait.until(isTrue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wait(Duration timeout) {
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            try {
                this.webDriver.wait(timeout.toMillis());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void waitForCurrentRequestEnd() {
        this.waitForCondition(webDriver1 -> this.webDriver.getResponseStatus() != -1, STD_TIMEOUT);
    }

    public void waitForCurrentRequestEnd(Duration timeout) {
        this.waitForCondition(webDriver1 -> this.webDriver.getResponseStatus() != -1, timeout);
    }

    public void waitReqJs() {
        this.waitReqJs(STD_TIMEOUT);
    }

    public void waitReqJs(Duration timeout) {
        this.wait(Duration.ofMillis(200L));
        this.waitForCurrentRequestEnd(timeout);
        this.waitForBackgroundJavascript(timeout, Duration.ofMillis(100L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForPageToLoad(Duration timeOut) {
        ExpectedCondition expectation = driver -> this.webDriver.getJSExecutor().executeScript("return document.readyState", new Object[0]).equals("complete");
        ExtendedWebDriver extendedWebDriver = this.webDriver;
        synchronized (extendedWebDriver) {
            WebDriverWait wait = new WebDriverWait((WebDriver)this.webDriver, timeOut);
            wait.until((Function)expectation);
        }
    }

    public void waitForPageToLoad() {
        this.waitForPageToLoad(STD_TIMEOUT);
    }

    public boolean isInPageText(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageText() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public boolean isInPageTextReduced(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageTextReduced() + values.replaceAll("\\s+", " ")).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public boolean matchesPageText(String regexp) {
        try {
            this.waitForCondition(webDriver1 -> this.webDriver.getPageText().matches(regexp), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public boolean matchesPageTextReduced(String regexp) {
        try {
            this.waitForCondition(webDriver1 -> this.webDriver.getPageTextReduced().matches(regexp), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public boolean isNotInPageText(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> !(this.webDriver.getPageText() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public boolean isInPage(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageSource() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public boolean isNotInPage(String text) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> !(this.webDriver.getPageSource() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public boolean isInPage(String text, boolean allowExceptions) {
        try {
            String values = this.getInputValues();
            this.waitForCondition(webDriver1 -> (this.webDriver.getPageSource() + values).contains(text), STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException exception) {
            if (allowExceptions) {
                throw exception;
            }
            exception.printStackTrace();
            return false;
        }
    }

    public <V> boolean isCondition(Function<? super WebDriver, V> isTrue) {
        try {
            this.waitForCondition(isTrue, STD_TIMEOUT);
            return true;
        }
        catch (TimeoutException ex) {
            return false;
        }
    }

    public WebElement findElement(By by) {
        return this.webDriver.findElement(by);
    }

    public List<WebElement> findElements(By by) {
        return this.webDriver.findElements(by);
    }

    public int getResponseStatus() {
        return this.webDriver.getResponseStatus();
    }

    public String getResponseBody() {
        return this.webDriver.getResponseBody();
    }

    public String getRequestData() {
        return this.webDriver.getRequestData();
    }

    public void postInit() {
        this.webDriver.postInit();
    }

    public JavascriptExecutor getJSExecutor() {
        return this.webDriver.getJSExecutor();
    }

    public void printProcessedResponses() {
        this.webDriver.printProcessedResponses();
    }

    public void get(String url) {
        this.webDriver.get(url);
    }

    public String getCurrentUrl() {
        return this.webDriver.getCurrentUrl();
    }

    public String getTitle() {
        return this.webDriver.getTitle();
    }

    public String getPageSource() {
        return this.webDriver.getPageSource();
    }

    public void close() {
        this.webDriver.close();
    }

    public void quit() {
        this.webDriver.quit();
    }

    public Set<String> getWindowHandles() {
        return this.webDriver.getWindowHandles();
    }

    public String getWindowHandle() {
        return this.webDriver.getWindowHandle();
    }

    public WebDriver.TargetLocator switchTo() {
        return this.webDriver.switchTo();
    }

    public WebDriver.Navigation navigate() {
        return this.webDriver.navigate();
    }

    public WebDriver.Options manage() {
        return this.webDriver.manage();
    }

    public List<WebElement> getAnchors() {
        return this.webDriver.findElements(By.cssSelector((String)"a[href]"));
    }

    private String getInputValues() {
        return this.webDriver.findElements(By.cssSelector((String)"input, textarea, select")).stream().map(webElement -> webElement.getAttribute("value")).reduce("", (str1, str2) -> str1 + " " + str2);
    }
}

