/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sessions.remote;

import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.internal.identitymaps.IdentityMapManager;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.DatabaseSessionImpl;
import org.eclipse.persistence.internal.sessions.DistributedSessionIdentityMapAccessor;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteConnection;
import org.eclipse.persistence.internal.sessions.remote.RemoteCursoredStream;
import org.eclipse.persistence.internal.sessions.remote.RemoteScrollableCursor;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.CursoredStreamPolicy;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ScrollableCursorPolicy;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public abstract class DistributedSession
extends DatabaseSessionImpl {
    protected transient RemoteConnection remoteConnection;
    protected boolean hasDefaultReadOnlyClasses;
    protected boolean isMetadataRemote = true;

    protected DistributedSession(int nothing) {
    }

    protected DistributedSession(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        this.remoteConnection.initialize(this);
        this.project = new Project();
    }

    @Override
    public abstract UnitOfWorkImpl acquireUnitOfWork();

    @Override
    public void beginTransaction() {
        this.getTransactionMutex().acquire();
        this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        this.getRemoteConnection().beginTransaction();
        this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
    }

    @Override
    public void commitTransaction() {
        this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        this.getRemoteConnection().commitTransaction();
        this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        this.getTransactionMutex().release();
    }

    public RemoteCursoredStream cursorSelectObjects(CursoredStreamPolicy policy) {
        return this.getRemoteConnection().cursorSelectObjects(policy, this);
    }

    public RemoteScrollableCursor cursorSelectObjects(ScrollableCursorPolicy policy) {
        return this.getRemoteConnection().cursorSelectObjects(policy, this);
    }

    @Override
    public Object executeQuery(String queryName) throws DatabaseException {
        return this.executeQuery(queryName, new Vector(1));
    }

    @Override
    public Object executeQuery(String queryName, Class<?> domainClass) throws DatabaseException {
        return this.executeQuery(queryName, domainClass, new Vector(1));
    }

    @Override
    public Object executeQuery(String queryName, Class<?> domainClass, Vector argumentValues) throws DatabaseException {
        this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        Transporter transporter = this.getRemoteConnection().remoteExecuteNamedQuery(queryName, domainClass, argumentValues);
        this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        transporter.getQuery().setSession(this);
        return transporter.getQuery().extractRemoteResult(transporter);
    }

    @Override
    public Object executeQuery(String queryName, Vector argumentValues) throws DatabaseException {
        if (this.containsQuery(queryName)) {
            return super.executeQuery(queryName, argumentValues);
        }
        return this.executeQuery(queryName, null, argumentValues);
    }

    @Override
    public abstract Object executeQuery(DatabaseQuery var1);

    @Override
    public Object executeQuery(DatabaseQuery query, AbstractRecord row) {
        query.setTranslationRow(row);
        return this.executeQuery(query);
    }

    @Override
    public List<Class<?>> getDefaultReadOnlyClasses() {
        if (this.isMetadataRemote && !this.hasDefaultReadOnlyClasses) {
            this.getProject().setDefaultReadOnlyClasses(this.getRemoteConnection().getDefaultReadOnlyClasses());
            this.hasDefaultReadOnlyClasses = true;
        }
        return super.getDefaultReadOnlyClasses();
    }

    @Override
    public ClassDescriptor getDescriptor(Class<?> domainClass) {
        ClassDescriptor descriptor = this.getDescriptors().get(domainClass);
        if (descriptor == null) {
            if (!this.isMetadataRemote) {
                return super.getDescriptor((Class)domainClass);
            }
            this.startOperationProfile("Timer:RemoteMetadata", null, Integer.MAX_VALUE);
            descriptor = this.getRemoteConnection().getDescriptor(domainClass);
            this.endOperationProfile("Timer:RemoteMetadata", null, Integer.MAX_VALUE);
            if (descriptor == null) {
                return super.getDescriptor((Class)domainClass);
            }
            this.getDescriptors().put(domainClass, descriptor);
            String alias = descriptor.getAlias();
            if (alias != null) {
                this.getProject().addAlias(alias, descriptor);
            }
            descriptor.remoteInitialization(this);
        }
        return descriptor;
    }

    @Override
    public ClassDescriptor getDescriptorForAlias(String alias) {
        ClassDescriptor descriptor = super.getDescriptorForAlias(alias);
        if (descriptor == null) {
            if (!this.isMetadataRemote) {
                return null;
            }
            this.startOperationProfile("Timer:RemoteMetadata", null, Integer.MAX_VALUE);
            descriptor = this.getRemoteConnection().getDescriptorForAlias(alias);
            this.endOperationProfile("Timer:RemoteMetadata", null, Integer.MAX_VALUE);
            if (descriptor == null) {
                return null;
            }
            this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
            this.getProject().addAlias(alias, descriptor);
            descriptor.remoteInitialization(this);
        }
        return descriptor;
    }

    public ClassDescriptor getDescriptorCorrespondingTo(ClassDescriptor descriptor) {
        return this.getDescriptors().get(descriptor.getJavaClass());
    }

    public abstract Object getObjectCorrespondingTo(Object var1, Map<Object, ObjectDescriptor> var2, Map<Object, Object> var3, ObjectLevelReadQuery var4);

    public abstract Object getObjectsCorrespondingToAll(Object var1, Map<Object, ObjectDescriptor> var2, Map<Object, Object> var3, ObjectLevelReadQuery var4, ContainerPolicy var5);

    public RemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public boolean hasCorrespondingDescriptor(ClassDescriptor descriptor) {
        return this.getDescriptors().containsKey(descriptor.getJavaClass());
    }

    @Override
    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new DistributedSessionIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public abstract Object instantiateRemoteValueHolderOnServer(RemoteValueHolder var1);

    @Override
    public boolean isConnected() {
        if (this.getRemoteConnection() == null) {
            return false;
        }
        return this.getRemoteConnection().isConnected();
    }

    @Override
    public boolean isDistributedSession() {
        return true;
    }

    @Override
    public boolean isRemoteSession() {
        return false;
    }

    public void privilegedAddDescriptor(ClassDescriptor descriptor) {
        this.getDescriptors().put(descriptor.getJavaClass(), descriptor);
    }

    @Override
    public void rollbackTransaction() {
        this.startOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        this.getRemoteConnection().rollbackTransaction();
        this.endOperationProfile("Timer:Remote", null, Integer.MAX_VALUE);
        this.getTransactionMutex().release();
    }

    public void setRemoteConnection(RemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "()";
    }

    @Override
    public void logout() {
        this.remoteConnection.release();
    }

    public boolean isMetadataRemote() {
        return this.isMetadataRemote;
    }

    public void setIsMetadataRemote(boolean isMetadataRemote) {
        this.isMetadataRemote = isMetadataRemote;
    }

    @Override
    public void connect() throws DatabaseException {
        this.remoteConnection.initialize(this);
    }

    @Override
    public void disconnect() throws DatabaseException {
        this.getSequencingHome().onDisconnect();
    }

    @Override
    public void loginAndDetectDatasource() throws DatabaseException {
        this.preConnectDatasource();
        this.connect();
        Login login = this.remoteConnection.getLogin();
        this.setLogin(login);
        this.postConnectDatasource();
    }

    @Override
    public void login() throws DatabaseException {
        this.preConnectDatasource();
        this.connect();
        Login login = this.remoteConnection.getLogin();
        this.setLogin(login);
        this.postConnectDatasource();
    }
}

