/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http.server;

import java.io.IOException;
import java.nio.CharBuffer;
import org.glassfish.grizzly.Cacheable;
import org.glassfish.grizzly.ReadHandler;
import org.glassfish.grizzly.http.io.InputBuffer;
import org.glassfish.grizzly.http.io.NIOReader;

final class NIOReaderImpl
extends NIOReader
implements Cacheable {
    private volatile InputBuffer inputBuffer;

    NIOReaderImpl() {
    }

    @Override
    public int read(CharBuffer target) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.read(target);
    }

    @Override
    public int read() throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.readChar();
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.read(cbuf, 0, cbuf.length);
    }

    @Override
    public long skip(long n) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.skip(n);
    }

    @Override
    public boolean ready() throws IOException {
        return this.isReady();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.inputBuffer.mark(readAheadLimit);
    }

    @Override
    public void reset() throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        this.inputBuffer.reset();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (!this.initialized()) {
            throw new IOException("Not initialized");
        }
        return this.inputBuffer.read(cbuf, off, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized()) {
            return;
        }
        this.inputBuffer.close();
    }

    @Override
    public void notifyAvailable(ReadHandler handler) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.inputBuffer.notifyAvailable(handler);
    }

    @Override
    public void notifyAvailable(ReadHandler handler, int size) {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        this.inputBuffer.notifyAvailable(handler, size);
    }

    @Override
    public boolean isFinished() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.isFinished();
    }

    @Override
    public int readyData() {
        if (!this.initialized()) {
            throw new IllegalStateException("Not initialized");
        }
        return this.inputBuffer.availableChar();
    }

    @Override
    public boolean isReady() {
        return this.readyData() > 0;
    }

    @Override
    public void recycle() {
        this.inputBuffer = null;
    }

    public void setInputBuffer(InputBuffer inputBuffer) {
        this.inputBuffer = inputBuffer;
    }

    private boolean initialized() {
        return this.inputBuffer != null;
    }
}

