/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.connectors.util;

import com.sun.appserv.connectors.internal.api.ConnectorRuntimeException;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.deployment.common.Descriptor;

public final class SetMethodAction<P extends EnvironmentProperty> {
    private static final Logger LOG = LogDomains.getLogger(SetMethodAction.class, (String)"jakarta.enterprise.resource.resourceadapter");
    private final Object bean;
    private final Set<P> props;
    private Method[] methods;

    public SetMethodAction(Object bean, Set<P> props) {
        this.bean = Objects.requireNonNull(bean, "The bean to be set must not be null.");
        this.props = Objects.requireNonNull(props, "Properties to be set to the bean must not be null.");
    }

    public Void run() throws Exception {
        this.methods = this.bean.getClass().getMethods();
        for (EnvironmentProperty prop : this.props) {
            Class<?> type;
            String resolvedValue = prop.getResolvedValue();
            if (resolvedValue == null || resolvedValue.isBlank()) continue;
            String propName = prop.getName();
            Method method = this.getSetter(propName, type = this.getTypeOf(prop));
            if (method == null) {
                LOG.log(Level.WARNING, "rardeployment.no_setter_method", new Object[]{prop.getName(), type, this.bean.getClass()});
                continue;
            }
            Object resolvedValueObject = prop.getResolvedValueObject(type);
            try {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "Invoking " + String.valueOf(method) + " on " + this.bean.getClass().getName() + " with value [" + String.valueOf(resolvedValueObject.getClass()) + ", " + SetMethodAction.getFilteredPropValue(prop) + "]");
                }
                method.invoke(this.bean, resolvedValueObject);
            }
            catch (IllegalArgumentException ia) {
                LOG.log(Level.WARNING, "IllegalArgumentException while trying to set " + prop.getName() + " and value " + SetMethodAction.getFilteredPropValue(prop), String.valueOf(ia) + " on an instance of " + String.valueOf(this.bean.getClass()) + " -- trying again with the type from bean");
                boolean origBoundsChecking = Descriptor.isBoundsChecking();
                if (!origBoundsChecking) {
                    throw ia;
                }
                try {
                    Descriptor.setBoundsChecking((boolean)false);
                    prop.setType(type.getName());
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "2nd try without bounds checking: Invoking " + String.valueOf(method) + " on " + this.bean.getClass().getName() + " with value [" + String.valueOf(resolvedValueObject.getClass()) + ", " + SetMethodAction.getFilteredPropValue(prop) + "]");
                    }
                    method.invoke(this.bean, resolvedValueObject);
                }
                catch (Exception e) {
                    throw this.createException(e, prop);
                }
                finally {
                    Descriptor.setBoundsChecking((boolean)origBoundsChecking);
                }
            }
            catch (Exception e) {
                throw this.createException(e, prop);
            }
        }
        return null;
    }

    private ConnectorRuntimeException createException(Exception ex, EnvironmentProperty prop) {
        String filteredPropValue = SetMethodAction.getFilteredPropValue(prop);
        LOG.log(Level.WARNING, "RAR7096: Exception while trying to set the value {0} on property {1} of {2}: {3}", new Object[]{filteredPropValue, prop.getName(), this.bean.getClass(), ex});
        return new ConnectorRuntimeException(ex.getMessage(), (Throwable)ex);
    }

    private static String getFilteredPropValue(EnvironmentProperty prop) {
        if (prop == null) {
            return "null";
        }
        String propname = prop.getName();
        if (propname.toLowerCase().contains("password")) {
            return "********";
        }
        return prop.getResolvedValue();
    }

    private Method getSetter(String propertyName, Class<?> parameterType) {
        String setterMethodName = "set" + this.getCamelCasedPropertyName(propertyName);
        Method[] setterMethods = this.findMethod(setterMethodName);
        if (setterMethods.length == 1) {
            return setterMethods[0];
        }
        for (Method setterMethod : setterMethods) {
            Class<?>[] paramTypes = setterMethod.getParameterTypes();
            if (paramTypes.length <= 0 || !paramTypes[0].equals(parameterType) || paramTypes.length != 1) continue;
            LOG.log(Level.FINER, "Method [{0}] matches with the right arg type", setterMethod);
            return setterMethod;
        }
        return null;
    }

    private Class<?> getTypeOf(EnvironmentProperty prop) throws ClassNotFoundException {
        String name = prop.getName();
        Method accessorMeth = this.getAccessorMethod(name);
        if (accessorMeth != null) {
            return accessorMeth.getReturnType();
        }
        LOG.log(Level.FINE, "method.name.nogetterforproperty", new Object[]{prop.getName(), this.bean.getClass()});
        return Class.forName(prop.getType());
    }

    private Method getAccessorMethod(String propertyName) {
        String getterName = "get" + this.getCamelCasedPropertyName(propertyName);
        Method[] getterMethods = this.findMethod(getterName);
        if (getterMethods.length > 0) {
            return getterMethods[0];
        }
        getterName = "is" + this.getCamelCasedPropertyName(propertyName);
        Method[] getterMethodsWithIsPrefix = this.findMethod(getterName);
        if (getterMethodsWithIsPrefix.length > 0 && (getterMethodsWithIsPrefix[0].getReturnType().equals(Boolean.class) || getterMethodsWithIsPrefix[0].getReturnType().equals(Boolean.TYPE))) {
            return getterMethodsWithIsPrefix[0];
        }
        return null;
    }

    private Method[] findMethod(String methodName) {
        ArrayList<Method> matchedMethods = new ArrayList<Method>();
        for (Method method : this.methods) {
            if (!method.getName().equals(methodName)) continue;
            matchedMethods.add(method);
        }
        for (Method method : this.methods) {
            if (!method.getName().equalsIgnoreCase(methodName)) continue;
            matchedMethods.add(method);
        }
        Method[] methodArray = new Method[matchedMethods.size()];
        return matchedMethods.toArray(methodArray);
    }

    private String getCamelCasedPropertyName(String propertyName) {
        return propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
    }
}

