/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.engine.constraintvalidation;

import jakarta.validation.ClockProvider;
import java.time.Duration;
import java.util.function.Supplier;
import org.hibernate.validator.constraintvalidation.HibernateConstraintValidatorInitializationContext;
import org.hibernate.validator.internal.engine.constraintvalidation.HibernateConstraintValidatorInitializationSharedDataManager;
import org.hibernate.validator.spi.scripting.ScriptEvaluator;
import org.hibernate.validator.spi.scripting.ScriptEvaluatorFactory;

public class HibernateConstraintValidatorInitializationContextImpl
implements HibernateConstraintValidatorInitializationContext {
    private final ScriptEvaluatorFactory scriptEvaluatorFactory;
    private final ClockProvider clockProvider;
    private final Duration temporalValidationTolerance;
    private final HibernateConstraintValidatorInitializationSharedDataManager constraintValidatorInitializationSharedServiceManager;
    private final int hashCode;

    public HibernateConstraintValidatorInitializationContextImpl(ScriptEvaluatorFactory scriptEvaluatorFactory, ClockProvider clockProvider, Duration temporalValidationTolerance, HibernateConstraintValidatorInitializationSharedDataManager constraintValidatorInitializationSharedServiceManager) {
        this.scriptEvaluatorFactory = scriptEvaluatorFactory;
        this.clockProvider = clockProvider;
        this.temporalValidationTolerance = temporalValidationTolerance;
        this.constraintValidatorInitializationSharedServiceManager = constraintValidatorInitializationSharedServiceManager;
        this.hashCode = this.createHashCode();
    }

    public static HibernateConstraintValidatorInitializationContextImpl of(HibernateConstraintValidatorInitializationContextImpl defaultContext, ScriptEvaluatorFactory scriptEvaluatorFactory, ClockProvider clockProvider, Duration temporalValidationTolerance, HibernateConstraintValidatorInitializationSharedDataManager constraintValidatorInitializationSharedServiceManager) {
        if (scriptEvaluatorFactory == defaultContext.scriptEvaluatorFactory && clockProvider == defaultContext.clockProvider && temporalValidationTolerance.equals(defaultContext.temporalValidationTolerance)) {
            return defaultContext;
        }
        return new HibernateConstraintValidatorInitializationContextImpl(scriptEvaluatorFactory, clockProvider, temporalValidationTolerance, constraintValidatorInitializationSharedServiceManager);
    }

    @Override
    public ScriptEvaluator getScriptEvaluatorForLanguage(String languageName) {
        return this.scriptEvaluatorFactory.getScriptEvaluatorByLanguageName(languageName);
    }

    @Override
    public ClockProvider getClockProvider() {
        return this.clockProvider;
    }

    @Override
    public Duration getTemporalValidationTolerance() {
        return this.temporalValidationTolerance;
    }

    @Override
    public <C> C getSharedData(Class<C> type) {
        return this.constraintValidatorInitializationSharedServiceManager.retrieve(type);
    }

    @Override
    public <C, V extends C> C getSharedData(Class<C> type, Supplier<V> createIfNotPresent) {
        return this.constraintValidatorInitializationSharedServiceManager.retrieve(type, createIfNotPresent);
    }

    public HibernateConstraintValidatorInitializationSharedDataManager getConstraintValidatorInitializationSharedServiceManager() {
        return this.constraintValidatorInitializationSharedServiceManager;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HibernateConstraintValidatorInitializationContextImpl hibernateConstraintValidatorInitializationContextImpl = (HibernateConstraintValidatorInitializationContextImpl)o;
        if (this.scriptEvaluatorFactory != hibernateConstraintValidatorInitializationContextImpl.scriptEvaluatorFactory) {
            return false;
        }
        if (this.constraintValidatorInitializationSharedServiceManager != hibernateConstraintValidatorInitializationContextImpl.constraintValidatorInitializationSharedServiceManager) {
            return false;
        }
        if (this.clockProvider != hibernateConstraintValidatorInitializationContextImpl.clockProvider) {
            return false;
        }
        return this.temporalValidationTolerance.equals(hibernateConstraintValidatorInitializationContextImpl.temporalValidationTolerance);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int createHashCode() {
        int result = System.identityHashCode(this.scriptEvaluatorFactory);
        result = 31 * result + System.identityHashCode(this.clockProvider);
        result = 31 * result + this.temporalValidationTolerance.hashCode();
        result = 31 * result + System.identityHashCode(this.constraintValidatorInitializationSharedServiceManager);
        return result;
    }
}

