/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.krazo.servlet;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import java.lang.annotation.Annotation;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.krazo.servlet.KrazoContainerInitializer;

@WebListener
public class KrazoServletContextListener
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(KrazoServletContextListener.class.getName());
    @Inject
    private BeanManager beanManager;

    public KrazoServletContextListener() {
    }

    public KrazoServletContextListener(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext servletContext = sce.getServletContext();
        Set controllerClasses = (Set)servletContext.getAttribute(KrazoContainerInitializer.CONTROLLER_CLASSES);
        if (controllerClasses == null || controllerClasses.isEmpty()) {
            return;
        }
        for (Class controllerClass : controllerClasses) {
            this.failIfNoCdiBean(controllerClass);
            this.warnIfAnnotatedWithNamed(controllerClass);
        }
    }

    private void failIfNoCdiBean(Class<?> controllerClass) {
        Set controllerBeans = this.beanManager.getBeans(controllerClass, new Annotation[0]);
        if (controllerBeans == null || controllerBeans.isEmpty()) {
            String message = String.format("The controller %s is not a managed CDI bean. If CDI bean discovery mode in not set to \"all\" in beans.xml, then controller classes need a scope annotation (e.g. @RequestScoped).", controllerClass.getName());
            throw new IllegalArgumentException(message);
        }
    }

    private void warnIfAnnotatedWithNamed(Class<?> controllerClass) {
        Named namedAnnotation = controllerClass.getAnnotation(Named.class);
        if (namedAnnotation != null) {
            String message = String.format("Controller class %s is annotated with @Named. Typically this should not be required, because you should never access the controller directly from a view.", controllerClass.getName());
            log.warning(message);
        }
    }
}

