/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.history;

import java.io.Serializable;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;

public class AsOfClause
implements Serializable {
    public static final AsOfClause NO_CLAUSE = new AsOfClause((Expression)null);
    private Object value;

    protected AsOfClause() {
    }

    public AsOfClause(Date date) {
        this.value = date;
    }

    public AsOfClause(Timestamp timestamp) {
        this.value = timestamp;
    }

    public AsOfClause(Calendar calendar) {
        this.value = calendar;
    }

    public AsOfClause(long time) {
        this.value = time;
    }

    public AsOfClause(Long time) {
        this.value = time;
    }

    protected AsOfClause(Number number) {
        this.value = number;
    }

    public AsOfClause(Expression expression) {
        this.value = expression;
    }

    protected AsOfClause(AsOfClause wrappedValue) {
        this.value = wrappedValue;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public void printSQL(ExpressionSQLPrinter printer) {
        printer.printString("AS OF TIMESTAMP (");
        Object value = this.getValue();
        if (value instanceof Expression) {
            ConstantExpression ce;
            Object object;
            Expression expression = (Expression)value;
            if (value instanceof ConstantExpression && (object = (ce = (ConstantExpression)value).getValue()) instanceof String) {
                String s = (String)object;
                printer.printString(s);
            } else {
                printer.printExpression(expression);
            }
        } else {
            ConversionManager converter = ConversionManager.getDefaultManager();
            value = converter.convertObject(value, ClassConstants.TIMESTAMP);
            printer.printPrimitive(value, true);
        }
        printer.printString(")");
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isAsOfSCNClause() {
        return false;
    }

    public boolean isUniversal() {
        return false;
    }

    public String toString() {
        StringWriter writer = new StringWriter();
        writer.write(this.getClass().getSimpleName());
        writer.write("(");
        writer.write(String.valueOf(this.getValue()));
        writer.write(")");
        return writer.toString();
    }
}

