/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.asm.internal;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import org.eclipse.persistence.asm.ASMFactory;
import org.eclipse.persistence.exceptions.ValidationException;

public final class Util {
    private Util() {
    }

    public static Object getFieldValue(Map<String, String> targetNames, String name, Class<?> type) {
        String asmService = ASMFactory.getAsmService();
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            String className = targetNames.get(asmService);
            if (className == null) {
                throw ValidationException.incorrectASMServiceProvided();
            }
            Class<?> clazz = Class.forName(className);
            VarHandle field = lookup.findStaticVarHandle(clazz, name, type);
            return field.get();
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            throw ValidationException.notAvailableASMService();
        }
    }
}

