/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.columns;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotation;
import org.eclipse.persistence.internal.jpa.metadata.tables.CheckConstraintMetadata;

public abstract class MetadataColumn
extends ORMetadata {
    private String m_name;
    private String m_columnDefinition;
    private String m_options;
    private String m_comment;
    private List<CheckConstraintMetadata> m_checkConstraints = new ArrayList<CheckConstraintMetadata>();

    protected MetadataColumn(MetadataAccessor accessor) {
        super(null, accessor);
    }

    protected MetadataColumn(MetadataAnnotation column, MetadataAccessor accessor) {
        super(column, accessor);
        if (column != null) {
            this.m_name = column.getAttributeString("name");
            this.m_columnDefinition = column.getAttributeString("columnDefinition");
            this.m_options = column.getAttributeString("options");
            this.m_comment = column.getAttributeString("comment");
            for (Object checkConstraint : column.getAttributeArray("check")) {
                this.m_checkConstraints.add(new CheckConstraintMetadata((MetadataAnnotation)checkConstraint, accessor));
            }
        }
    }

    protected MetadataColumn(String xmlElement) {
        super(xmlElement);
    }

    @Override
    public boolean equals(Object objectToCompare) {
        if (objectToCompare instanceof MetadataColumn) {
            MetadataColumn column = (MetadataColumn)objectToCompare;
            if (!this.valuesMatch(this.m_columnDefinition, column.getColumnDefinition())) {
                return false;
            }
            if (!this.valuesMatch(this.m_name, column.getName())) {
                return false;
            }
            if (!this.valuesMatch(this.m_comment, column.getComment())) {
                return false;
            }
            if (!this.valuesMatch(this.m_checkConstraints, column.getCheckConstraints())) {
                return false;
            }
            return this.valuesMatch(this.m_options, column.getOptions());
        }
        return false;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.m_name != null ? this.m_name.hashCode() : 0);
        result = 31 * result + (this.m_columnDefinition != null ? this.m_columnDefinition.hashCode() : 0);
        result = 31 * result + (this.m_options != null ? this.m_options.hashCode() : 0);
        result = 31 * result + (this.m_comment != null ? this.m_comment.hashCode() : 0);
        result = 31 * result + (this.m_checkConstraints != null ? this.m_checkConstraints.hashCode() : 0);
        return result;
    }

    public List<CheckConstraintMetadata> getCheckConstraints() {
        return this.m_checkConstraints;
    }

    public String getColumnDefinition() {
        return this.m_columnDefinition;
    }

    public String getComment() {
        return this.m_comment;
    }

    public DatabaseField getDatabaseField() {
        DatabaseField databaseField = new DatabaseField();
        this.setFieldName(databaseField, this.m_name == null ? "" : this.m_name);
        databaseField.setColumnDefinition(this.m_columnDefinition == null ? "" : this.m_columnDefinition);
        databaseField.setComment(this.m_comment);
        databaseField.setOptionalSuffix(this.m_options);
        return databaseField;
    }

    public String getName() {
        return this.m_name;
    }

    public String getOptions() {
        return this.m_options;
    }

    public void setCheckConstraints(List<CheckConstraintMetadata> checkConstraints) {
        this.m_checkConstraints = checkConstraints;
    }

    public void setColumnDefinition(String columnDefinition) {
        this.m_columnDefinition = columnDefinition;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setOptions(String options) {
        this.m_options = options;
    }
}

