/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.schema2beansdev.gen;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;

public class GenBuffer
extends Writer {
    protected int INITIAL_BUFFER_CAPACITY = 512;
    protected int curOut;
    protected StringBuffer[] listOut;
    protected int bufferCount;
    protected Stack selectStack = new Stack();
    private boolean first = false;
    private String separator = null;
    private CharArrayWriter caw = null;

    public GenBuffer(int bufferCount) {
        this.bufferCount = bufferCount;
        this.listOut = new StringBuffer[bufferCount];
        this.privateInit();
    }

    public GenBuffer(GenBuffer source) {
        this.bufferCount = source.bufferCount;
        this.listOut = new StringBuffer[this.bufferCount];
        this.INITIAL_BUFFER_CAPACITY = source.INITIAL_BUFFER_CAPACITY;
        this.curOut = source.curOut;
        this.first = source.first;
        this.separator = source.separator;
        this.privateInit();
    }

    public void reset() {
        this.privateInit();
    }

    private void privateInit() {
        for (int i = 0; i < this.bufferCount; ++i) {
            this.listOut[i] = new StringBuffer();
            this.listOut[i].ensureCapacity(this.INITIAL_BUFFER_CAPACITY);
        }
    }

    public void insertAdditionalBuffers(int offset, int count) {
        StringBuffer[] newListOut = new StringBuffer[this.bufferCount + count];
        System.arraycopy(this.listOut, 0, newListOut, 0, offset + 1);
        System.arraycopy(this.listOut, offset + 1, newListOut, offset + 1 + count, this.bufferCount - offset - 1);
        for (int i = 0; i < count; ++i) {
            newListOut[offset + 1 + i] = new StringBuffer();
            newListOut[offset + 1 + i].ensureCapacity(this.INITIAL_BUFFER_CAPACITY);
        }
        this.bufferCount += count;
        this.listOut = newListOut;
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }

    public void select(int bufferNum) {
        if (bufferNum >= this.bufferCount || bufferNum < 0) {
            throw new IllegalArgumentException("Invalid bufferNum " + bufferNum + " out of " + this.bufferCount);
        }
        this.curOut = bufferNum;
    }

    public void pushSelect(int bufferNum) {
        int prevOut = this.curOut;
        this.select(bufferNum);
        this.selectStack.push(new Integer(prevOut));
    }

    public void popSelect() {
        this.curOut = (Integer)this.selectStack.pop();
    }

    protected void beforeWriteHook() {
    }

    public void write(boolean b) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(b);
    }

    public void write(char c) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(c);
    }

    @Override
    public void write(char[] str) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(str);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(cbuf, off, len);
    }

    public void write(double d) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(d);
    }

    public void write(float f) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(f);
    }

    @Override
    public void write(int i) throws IOException {
        if (this.caw == null) {
            this.caw = new CharArrayWriter(2);
        }
        this.caw.write(i);
        this.beforeWriteHook();
        this.listOut[this.curOut].append(this.caw.toString());
        this.caw.reset();
    }

    public void write(long l) throws IOException {
        this.write((int)l);
    }

    public void write(Object obj) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(obj);
    }

    @Override
    public void write(String s) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s);
    }

    public void write(StringBuffer s) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s);
    }

    public void write(String s1, String s2) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s1);
        this.listOut[this.curOut].append(s2);
    }

    public void write(String s1, String s2, String s3) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s1);
        this.listOut[this.curOut].append(s2);
        this.listOut[this.curOut].append(s3);
    }

    public void write(String s1, String s2, String s3, String s4) throws IOException {
        this.beforeWriteHook();
        this.listOut[this.curOut].append(s1);
        this.listOut[this.curOut].append(s2);
        this.listOut[this.curOut].append(s3);
        this.listOut[this.curOut].append(s4);
    }

    public void write(String str, int bufferNum) throws IOException {
        if (bufferNum >= this.bufferCount || bufferNum < 0) {
            throw new IllegalArgumentException("Invalid bufferNum " + bufferNum + " out of " + this.bufferCount);
        }
        this.beforeWriteHook();
        this.listOut[bufferNum].append(str);
    }

    public void setFirst(String separator) {
        this.first = true;
        this.separator = separator;
    }

    public void writeNext(String msg) throws IOException {
        this.writeNext();
        this.write(msg);
    }

    public void writeNext(String msg1, String msg2) throws IOException {
        this.writeNext();
        this.write(msg1);
        this.write(msg2);
    }

    public void writeNext(String msg1, String msg2, String msg3) throws IOException {
        this.writeNext();
        this.write(msg1);
        this.write(msg2);
        this.write(msg3);
    }

    public void writeNext() throws IOException {
        if (this.first) {
            this.first = false;
        } else {
            this.write(this.separator);
        }
    }

    public void writeTo(Writer out) throws IOException {
        for (int i = 0; i < this.bufferCount; ++i) {
            out.write(this.listOut[i].toString());
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        for (int i = 0; i < this.bufferCount; ++i) {
            out.write(this.listOut[i].toString().getBytes());
        }
    }

    public void writeTo(StringBuffer out) {
        for (int i = 0; i < this.bufferCount; ++i) {
            out.append(this.listOut[i]);
        }
    }

    public void writeTo(GenBuffer out) {
        int i;
        int minInCommonBufferCount = this.bufferCount;
        if (out.bufferCount < this.bufferCount) {
            minInCommonBufferCount = out.bufferCount;
        }
        for (i = 0; i < minInCommonBufferCount; ++i) {
            out.listOut[i].append(this.listOut[i]);
        }
        if (out.bufferCount < this.bufferCount) {
            for (i = minInCommonBufferCount; i < this.bufferCount; ++i) {
                out.listOut[minInCommonBufferCount - 1].append(this.listOut[i]);
            }
        } else {
            out.curOut = this.curOut;
        }
        out.first = this.first;
        out.separator = this.separator;
    }

    public boolean anyContent() {
        for (int i = 0; i < this.bufferCount; ++i) {
            if (this.listOut[i].length() <= 0) continue;
            return true;
        }
        return false;
    }

    public int getCurrentPosition() {
        return this.listOut[this.curOut].length();
    }

    public void truncateAtPosition(int pos) {
        this.listOut[this.curOut].setLength(pos);
    }

    public StringBuffer getBuffer() {
        return this.listOut[this.curOut];
    }

    public void ensureCapacity(int minimumCapacity) {
        for (int i = 0; i < this.bufferCount; ++i) {
            this.listOut[i].ensureCapacity(minimumCapacity);
        }
    }
}

