/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin.progress;

import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.progress.ProgressStatusEvent;

public class ProgressStatusEventSet
extends ProgressStatusEvent {
    private Integer totalStepCount;
    private Integer currentStepCount;

    public ProgressStatusEventSet(String id, Integer totalStepCount, Integer currentStepCount) {
        super(id);
        this.totalStepCount = totalStepCount;
        this.currentStepCount = currentStepCount;
    }

    public ProgressStatusEventSet(String progressStatusId) {
        super(progressStatusId);
    }

    public Integer getTotalStepCount() {
        return this.totalStepCount;
    }

    public Integer getCurrentStepCount() {
        return this.currentStepCount;
    }

    public void setTotalStepCount(Integer totalStepCount) {
        this.totalStepCount = totalStepCount;
    }

    public void setCurrentStepCount(Integer currentStepCount) {
        this.currentStepCount = currentStepCount;
    }

    @Override
    public ProgressStatus apply(ProgressStatus ps) {
        if (this.totalStepCount != null) {
            ps.setTotalStepCount(this.totalStepCount);
        }
        if (this.currentStepCount != null) {
            ps.setCurrentStepCount(this.currentStepCount);
        }
        return ps;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + (this.totalStepCount != null ? this.totalStepCount.hashCode() : 0);
        hash = 53 * hash + (this.currentStepCount != null ? this.currentStepCount.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProgressStatusEventSet other = (ProgressStatusEventSet)obj;
        if (this.totalStepCount == null ? other.totalStepCount != null : !this.totalStepCount.equals(other.totalStepCount)) {
            return false;
        }
        return !(this.currentStepCount == null ? other.currentStepCount != null : !this.currentStepCount.equals(other.currentStepCount));
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[id=" + this.getSourceId() + ", progress=" + this.getCurrentStepCount() + "/" + this.getTotalStepCount() + "]";
    }
}

