/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.web.plugin.common;

import com.sun.enterprise.config.serverbeans.Application;
import java.text.MessageFormat;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RestParam;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.web.config.serverbeans.EnvEntry;
import org.glassfish.web.config.serverbeans.WebModuleConfig;
import org.glassfish.web.plugin.common.WebModuleConfigCommand;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-web-env-entry")
@I18n(value="listWebEnvEntry.command")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@RestEndpoints(value={@RestEndpoint(configBean=Application.class, opType=RestEndpoint.OpType.GET, path="list-web-env-entry", description="list-web-env-entry", params={@RestParam(name="id", value="$parent")})})
public class ListWebEnvEntryCommand
extends WebModuleConfigCommand {
    @Param(name="name", optional=true)
    private String name;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        WebModuleConfig config = this.webModuleConfig(report);
        if (config == null) {
            return;
        }
        ActionReport.MessagePart part = report.getTopMessagePart();
        String format = localStrings.getLocalString("listWebEnvEntryFormat", "{0} ({1}) = {2} ignoreDescriptorItem={3} //{4}");
        int reported = 0;
        for (EnvEntry entry : config.envEntriesMatching(this.name)) {
            ActionReport.MessagePart childPart = part.addChild();
            childPart.setMessage(MessageFormat.format(format, entry.getEnvEntryName(), entry.getEnvEntryType(), entry.getEnvEntryValue(), entry.getIgnoreDescriptorItem(), this.descriptionValueOrNotSpecified(entry.getDescription())));
            ++reported;
        }
        this.succeed(report, "listSummary", "Reported {0,choice,0#no {1} settings|1#one {1} setting|1<{0,number,integer} {1} settings}", reported, "env-entry");
    }
}

