/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;

public class RestClient {
    protected String host;
    protected int port;
    protected Client client;
    protected boolean useSsl = false;

    public RestClient() {
        this("localhost", 4848, false, null, null);
    }

    public RestClient(String host, int port, boolean useSsl) {
        this(host, port, useSsl, null, null);
    }

    public RestClient(String host, int port, boolean useSsl, String user, String password) {
        this.host = host;
        this.port = port;
        this.useSsl = useSsl;
        this.client = ClientBuilder.newClient();
        this.client.register((Object)new CsrfProtectionFilter());
        if (user != null) {
            this.client.register((Object)HttpAuthenticationFeature.basic((String)user, (String)password));
        }
    }

    public String getRestUrl() {
        return (this.useSsl ? "https" : "http") + "://" + this.host + ":" + this.port + "/management";
    }
}

