/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.tools.ij;

import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.tools.ij.URLCheck;

public class AttributeHolder {
    String name;
    String value;
    String token;
    Vector<String> errors = new Vector();

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    String getValue() {
        return this.value;
    }

    public void setValue(String string) {
        this.value = string;
    }

    String getToken() {
        return this.token;
    }

    public void setToken(String string) {
        this.token = string;
    }

    public void addError(String string) {
        if (!this.errors.contains(string)) {
            this.errors.addElement(string);
        }
    }

    public void check(Vector vector) {
        this.checkName(vector);
        this.displayErrors();
    }

    void displayErrors() {
        Enumeration<String> enumeration = this.errors.elements();
        if (enumeration.hasMoreElements()) {
            this.display(LocalizedResource.getMessage("TL_urlLabel1", "[", this.getToken(), "]"));
        }
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            this.displayIndented(string);
        }
    }

    void checkName(Vector vector) {
        if (vector == null) {
            return;
        }
        String string = this.getName();
        try {
            if (!vector.contains(string)) {
                if (vector.contains(string.toLowerCase(Locale.ENGLISH))) {
                    this.errors.addElement(LocalizedResource.getMessage("TL_incorCase", new Object[0]));
                } else {
                    this.errors.addElement(LocalizedResource.getMessage("TL_unknownAtt", new Object[0]));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void checkValue() {
        String string = this.getName();
        String string2 = this.getValue();
        try {
            if (URLCheck.getBooleanAttributes().contains(string) && !this.checkBoolean(string2)) {
                this.errors.addElement(LocalizedResource.getMessage("TL_trueFalse", new Object[0]));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    boolean checkBoolean(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase(Locale.ENGLISH).equals("true") || string.toLowerCase(Locale.ENGLISH).equals("false");
    }

    void display(String string) {
        LocalizedResource.OutputWriter().println(string);
    }

    void displayIndented(String string) {
        LocalizedResource.OutputWriter().println("   " + string);
    }
}

