/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.ee.authentication.glassfish.pam;

import com.sun.enterprise.security.auth.realm.Realm;
import com.sun.enterprise.security.auth.realm.exceptions.BadRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchRealmException;
import com.sun.enterprise.security.auth.realm.exceptions.NoSuchUserException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.libpam.PAM;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.UnixUser;

@Service
public final class PamRealm
extends Realm {
    public static final String AUTH_TYPE = "pam";
    private static final String PAM_SERVICE = "sshd";

    public synchronized void init(Properties props) throws BadRealmException, NoSuchRealmException {
        super.init(props);
        String jaasCtx = props.getProperty("jaas-context");
        if (jaasCtx == null) {
            throw new BadRealmException("No jaas-context defined");
        }
        this.setProperty("jaas-context", jaasCtx);
    }

    public String getAuthType() {
        return AUTH_TYPE;
    }

    public String[] authenticate(String username, String password) {
        UnixUser user = null;
        try {
            user = new PAM(this.getPamService()).authenticate(username, password);
        }
        catch (PAMException e) {
            _logger.log(Level.SEVERE, "pam_exception_authenticate", e);
        }
        if (user == null) {
            return null;
        }
        _logger.log(Level.FINE, () -> "PAM login succeeded for: " + username);
        String[] groups = null;
        Set groupSet = user.getGroups();
        groups = groupSet != null ? (String[])groupSet.toArray(String[]::new) : new String[]{};
        return groups;
    }

    public Enumeration<String> getGroupNames(String username) throws NoSuchUserException {
        try {
            return Collections.enumeration(new UnixUser(username).getGroups());
        }
        catch (PAMException ex) {
            Logger.getLogger(PamRealm.class.getName()).log(Level.SEVERE, "pam_exception_getgroupsofuser", ex);
            return null;
        }
    }

    public String getPamService() {
        return PAM_SERVICE;
    }
}

