/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.cluster.LocalInstanceCommand;
import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.universal.process.KillNotPossibleException;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import java.io.File;
import java.net.ConnectException;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="stop-local-instance")
@PerLookup
public class StopLocalInstanceCommand
extends LocalInstanceCommand {
    @Param(optional=true, defaultValue="true")
    private Boolean force;
    @Param(name="instance_name", primary=true, optional=true)
    private String userArgInstanceName;
    @Param(optional=true, defaultValue="false")
    private Boolean kill;
    @Param(optional=true)
    private Integer timeout;

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        this.instanceName = this.userArgInstanceName;
        super.validate();
    }

    @Override
    protected boolean mkdirs(File f) {
        return false;
    }

    protected Duration getTimeout() {
        return this.timeout == null ? null : Duration.ofSeconds(this.timeout.intValue());
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        File serverDir = this.getServerDirs().getServerDir();
        if (serverDir == null || !serverDir.isDirectory()) {
            return this.noSuchInstance();
        }
        if (this.getServerDirs().getLocalPassword() == null) {
            return this.instanceNotRunning();
        }
        HostAndPort addr = this.getReachableAdminAddress();
        if (addr == null) {
            return this.instanceNotRunning();
        }
        this.programOpts.setHostAndPort(addr);
        logger.log(Level.FINER, "Stopping server at {0}", addr);
        if (!ProcessUtils.isAlive((File)this.getServerDirs().getPidFile())) {
            return this.instanceNotRunning();
        }
        logger.finer("It's the correct Instance");
        this.doCommand();
        return 0;
    }

    protected int instanceNotRunning() throws CommandException {
        logger.log(Level.FINE, "instanceNotRunning()");
        if (this.kill.booleanValue()) {
            try {
                File lastPid = this.getServerDirs().getLastPidFile();
                ProcessUtils.kill((File)lastPid, (Duration)this.getStopTimeout(), (!this.programOpts.isTerse() ? 1 : 0) != 0);
            }
            catch (KillNotPossibleException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                return -1;
            }
        }
        logger.warning(Strings.get("StopInstance.instanceNotRunning"));
        return 0;
    }

    private int noSuchInstance() {
        logger.warning(Strings.get("Instance.noSuchInstance"));
        return 0;
    }

    protected void doCommand() throws CommandException {
        this.setLocalPassword();
        this.programOpts.setInteractive(false);
        Long pid = this.getServerPid();
        boolean printDots = !this.programOpts.isTerse();
        RemoteCLICommand cmd = new RemoteCLICommand("_stop-instance", this.programOpts, this.env);
        try {
            boolean dead;
            try {
                cmd.executeAndReturnOutput(new String[]{"_stop-instance", "--force", this.force.toString()});
            }
            catch (CommandException e) {
                if (e.getCause() instanceof ConnectException) {
                    logger.log(Level.FINE, "Remote _stop-instance call thrown a ConnectException. It is usual on Windows, where immediately after port closes, firewalls break any connection even before we can process the response. However it is not critical, we will still monitor the PID.", e);
                }
                throw e;
            }
            if (printDots) {
                System.out.print(Strings.get("StopInstance.waitForDeath") + " ");
            }
            boolean bl = dead = pid == null || ProcessUtils.waitWhileIsAlive((long)pid, (Duration)this.getStopTimeout(), (boolean)printDots);
            if (!dead) {
                throw new CommandException(MessageFormat.format("Timed out {0} seconds waiting for the instance to stop.", this.getStopTimeout().toSeconds()));
            }
        }
        catch (Exception e) {
            logger.log(Level.CONFIG, "Remote stop-instance call failed.", e);
            if (this.kill.booleanValue()) {
                try {
                    File prevPid = this.getServerDirs().getLastPidFile();
                    ProcessUtils.kill((File)prevPid, (Duration)this.getStopTimeout(), (boolean)printDots);
                    return;
                }
                catch (Exception ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    private Duration getStopTimeout() {
        Duration parameter = this.getTimeout();
        return parameter == null ? CLIConstants.DEATH_TIMEOUT_MS : parameter;
    }
}

