/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.exceptions.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;

public final class ExceptionMessageGenerator {
    private static final String CR = PrivilegedAccessHelper.getSystemProperty("line.separator");

    private ExceptionMessageGenerator() {
    }

    public static ClassLoader getLoader() {
        ClassLoader loader = ExceptionMessageGenerator.class.getClassLoader();
        if (loader == null) {
            loader = ConversionManager.getDefaultManager().getLoader();
        }
        return loader;
    }

    public static String buildMessage(Class<?> exceptionClass, int errorNumber, Object[] arguments) {
        String shortClassName = Helper.getShortClassName(exceptionClass);
        String message = "";
        ResourceBundle bundle = null;
        for (int i = 0; i < arguments.length; ++i) {
            if (arguments[i] != null) continue;
            arguments[i] = "null";
        }
        bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n." + shortClassName + "Resource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
        try {
            message = bundle.getString(String.valueOf(errorNumber));
        }
        catch (MissingResourceException mre) {
            bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            String noTranslationMessage = bundle.getString("NoExceptionTranslationForThisLocale");
            Object[] args = new Object[]{CR};
            return ExceptionMessageGenerator.format(message, arguments) + ExceptionMessageGenerator.format(noTranslationMessage, args);
        }
        return ExceptionMessageGenerator.format(message, arguments);
    }

    protected static String format(String message, Object[] arguments) {
        try {
            return MessageFormat.format(message, arguments);
        }
        catch (Exception ex) {
            ResourceBundle bundle = null;
            bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            String errorMessage = bundle.getString("ErrorFormattingMessage");
            Vector<Object> vec = new Vector<Object>();
            if (arguments != null) {
                for (int index = 0; index < arguments.length; ++index) {
                    try {
                        vec.add(arguments[index].toString());
                        continue;
                    }
                    catch (Exception ex2) {
                        vec.add(ex2);
                    }
                }
            }
            return MessageFormat.format(errorMessage, message, vec);
        }
    }

    public static String getHeader(String headerLabel) {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle("org.eclipse.persistence.exceptions.i18n.ExceptionResource", Locale.getDefault(), ExceptionMessageGenerator.getLoader());
            return bundle.getString(headerLabel);
        }
        catch (MissingResourceException mre) {
            return "[" + headerLabel + "]";
        }
    }
}

