/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.CommonResourceBundleDescriptor;
import com.sun.enterprise.deployment.EjbApplicationExceptionInfo;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerFactoryReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.InjectionCapable;
import com.sun.enterprise.deployment.InjectionInfo;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.NameValuePairDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.deployment.types.EjbReferenceContainer;
import com.sun.enterprise.deployment.types.EntityManagerFactoryReference;
import com.sun.enterprise.deployment.types.EntityManagerReference;
import com.sun.enterprise.deployment.types.MessageDestinationReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceEnvReferenceContainer;
import com.sun.enterprise.deployment.types.ResourceReferenceContainer;
import com.sun.enterprise.deployment.types.ServiceReferenceContainer;
import com.sun.enterprise.deployment.util.ComponentVisitor;
import com.sun.enterprise.deployment.util.DOLUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.security.common.Role;

public abstract class EjbBundleDescriptor
extends CommonResourceBundleDescriptor
implements WritableJndiNameEnvironment,
EjbReferenceContainer,
ResourceEnvReferenceContainer,
ResourceReferenceContainer,
ServiceReferenceContainer,
MessageDestinationReferenceContainer {
    private static final long serialVersionUID = 1L;
    private static final System.Logger LOG = DOLUtils.getLogger();
    private Boolean disableNonportableJndiNames;
    private final Map<String, EjbApplicationExceptionInfo> applicationExceptions = new HashMap<String, EjbApplicationExceptionInfo>();
    private final Set<EjbDescriptor> ejbs = new HashSet<EjbDescriptor>();
    private final Set<EjbReferenceDescriptor> ejbReferences = new HashSet<EjbReferenceDescriptor>();
    private final List<NameValuePairDescriptor> enterpriseBeansProperties = new ArrayList<NameValuePairDescriptor>();
    private final Set<EntityManagerFactoryReferenceDescriptor> entityManagerFactoryReferences = new HashSet<EntityManagerFactoryReferenceDescriptor>();
    private final Set<EntityManagerReferenceDescriptor> entityManagerReferences = new HashSet<EntityManagerReferenceDescriptor>();
    private final Set<EnvironmentProperty> environmentProperties = new HashSet<EnvironmentProperty>();
    private final Map<String, EjbInterceptor> interceptors = new HashMap<String, EjbInterceptor>();
    private final Set<MessageDestinationReferenceDescriptor> messageDestReferences = new HashSet<MessageDestinationReferenceDescriptor>();
    private final Set<ResourceEnvReferenceDescriptor> resourceEnvReferences = new HashSet<ResourceEnvReferenceDescriptor>();
    private final Set<ResourceReferenceDescriptor> resourceReferences = new HashSet<ResourceReferenceDescriptor>();
    private final Set<ServiceReferenceDescriptor> serviceReferences = new HashSet<ServiceReferenceDescriptor>();

    protected abstract EjbDescriptor createDummyEjbDescriptor(String var1);

    @Override
    public ArchiveType getModuleType() {
        return DOLUtils.ejbType();
    }

    public Boolean getDisableNonportableJndiNames() {
        return this.disableNonportableJndiNames;
    }

    public void setDisableNonportableJndiNames(String disable) {
        this.disableNonportableJndiNames = Boolean.valueOf(disable);
    }

    public Map<String, EjbApplicationExceptionInfo> getApplicationExceptions() {
        return new HashMap<String, EjbApplicationExceptionInfo>(this.applicationExceptions);
    }

    public void addApplicationException(EjbApplicationExceptionInfo appExc) {
        this.applicationExceptions.put(appExc.getExceptionClassName(), appExc);
    }

    public boolean isEmpty() {
        return this.ejbs.isEmpty();
    }

    public Set<? extends EjbDescriptor> getEjbs() {
        return Collections.unmodifiableSet(this.ejbs);
    }

    public boolean hasEjbByName(String name) {
        for (EjbDescriptor ejb : this.ejbs) {
            if (!ejb.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public EjbDescriptor getEjbByName(String name) {
        return this.getEjbByName(name, false);
    }

    public EjbDescriptor getEjbByName(String name, boolean isCreateDummy) {
        for (EjbDescriptor next : this.ejbs) {
            if (!next.getName().equals(name)) continue;
            return next;
        }
        if (!isCreateDummy) {
            throw new IllegalArgumentException("Referencing error: this bundle has no bean of name: " + name);
        }
        EjbDescriptor dummyEjbDesc = this.createDummyEjbDescriptor(name);
        this.addEjb(dummyEjbDesc);
        return dummyEjbDesc;
    }

    public EjbDescriptor[] getEjbByClassName(String className) {
        ArrayList<EjbDescriptor> ejbList = new ArrayList<EjbDescriptor>();
        for (EjbDescriptor ejb : this.ejbs) {
            if (!className.equals(ejb.getEjbClassName())) continue;
            ejbList.add(ejb);
        }
        return (EjbDescriptor[])ejbList.toArray(EjbDescriptor[]::new);
    }

    public EjbDescriptor[] getEjbBySEIName(String className) {
        ArrayList<EjbDescriptor> ejbList = new ArrayList<EjbDescriptor>();
        for (EjbDescriptor ejb : this.ejbs) {
            if (!className.equals(ejb.getWebServiceEndpointInterfaceName())) continue;
            ejbList.add(ejb);
        }
        return (EjbDescriptor[])ejbList.toArray(EjbDescriptor[]::new);
    }

    public Set<ServiceReferenceDescriptor> getEjbServiceReferenceDescriptors() {
        OrderedSet<ServiceReferenceDescriptor> serviceRefs = new OrderedSet<ServiceReferenceDescriptor>();
        for (EjbDescriptor ejb : this.ejbs) {
            serviceRefs.addAll(ejb.getServiceReferenceDescriptors());
        }
        return serviceRefs;
    }

    @Override
    public boolean hasWebServiceClients() {
        for (EjbDescriptor next : this.ejbs) {
            Set<ServiceReferenceDescriptor> serviceRefs = next.getServiceReferenceDescriptors();
            if (serviceRefs.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void addEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(this);
        this.ejbs.add(ejbDescriptor);
    }

    public void removeEjb(EjbDescriptor ejbDescriptor) {
        ejbDescriptor.setEjbBundleDescriptor(null);
        this.ejbs.remove(ejbDescriptor);
    }

    @Override
    public Set<EjbReferenceDescriptor> getEjbReferenceDescriptors() {
        return this.ejbReferences;
    }

    @Override
    public EjbReferenceDescriptor getEjbReference(String name) {
        for (EjbReferenceDescriptor reference : this.ejbReferences) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException(MessageFormat.format("This ejb jar [{0}] has no ejb reference by the name of [{1}] ", this.getName(), name));
    }

    @Override
    public void addEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.ejbReferences.add(ejbReference);
        ejbReference.setReferringBundleDescriptor(this);
    }

    @Override
    public void removeEjbReferenceDescriptor(EjbReferenceDescriptor ejbReference) {
        this.ejbReferences.remove(ejbReference);
    }

    @Override
    public Collection<? extends PersistenceUnitDescriptor> findReferencedPUs() {
        HashSet<PersistenceUnitDescriptor> persistenceUnits = new HashSet<PersistenceUnitDescriptor>();
        for (EjbDescriptor ejbDescriptor : this.ejbs) {
            persistenceUnits.addAll(EjbBundleDescriptor.findReferencedPUsViaPURefs(ejbDescriptor));
            persistenceUnits.addAll(EjbBundleDescriptor.findReferencedPUsViaPCRefs(ejbDescriptor));
        }
        for (EntityManagerFactoryReference entityManagerFactoryReference : this.getEntityManagerFactoryReferenceDescriptors()) {
            persistenceUnits.add(EjbBundleDescriptor.findReferencedPUViaEMFRef(entityManagerFactoryReference));
        }
        for (EntityManagerReference entityManagerReference : this.getEntityManagerReferenceDescriptors()) {
            persistenceUnits.add(EjbBundleDescriptor.findReferencedPUViaEMRef(entityManagerReference));
        }
        return persistenceUnits;
    }

    public List<NameValuePairDescriptor> getEnterpriseBeansProperties() {
        return this.enterpriseBeansProperties;
    }

    public String getEnterpriseBeansProperty(String key) {
        for (NameValuePairDescriptor property : this.enterpriseBeansProperties) {
            if (!property.getName().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    public void addEnterpriseBeansProperty(NameValuePairDescriptor newProp) {
        this.enterpriseBeansProperties.add(newProp);
    }

    @Override
    public Set<EntityManagerFactoryReferenceDescriptor> getEntityManagerFactoryReferenceDescriptors() {
        return this.entityManagerFactoryReferences;
    }

    @Override
    public EntityManagerFactoryReferenceDescriptor getEntityManagerFactoryReferenceByName(String name) {
        for (EntityManagerFactoryReferenceDescriptor reference : this.getEntityManagerFactoryReferenceDescriptors()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException("No entity manager factory reference of name " + name);
    }

    @Override
    public void addEntityManagerFactoryReferenceDescriptor(EntityManagerFactoryReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.entityManagerFactoryReferences.add(reference);
    }

    @Override
    public Set<EntityManagerReferenceDescriptor> getEntityManagerReferenceDescriptors() {
        return this.entityManagerReferences;
    }

    @Override
    public EntityManagerReferenceDescriptor getEntityManagerReferenceByName(String name) {
        for (EntityManagerReferenceDescriptor reference : this.entityManagerReferences) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException("No entity manager reference of name " + name);
    }

    @Override
    public void addEntityManagerReferenceDescriptor(EntityManagerReferenceDescriptor reference) {
        reference.setReferringBundleDescriptor(this);
        this.entityManagerReferences.add(reference);
    }

    @Override
    public Set<EnvironmentProperty> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    @Override
    public EnvironmentProperty getEnvironmentPropertyByName(String name) {
        for (EnvironmentProperty ev : this.environmentProperties) {
            if (!ev.getName().equals(name)) continue;
            return ev;
        }
        throw new IllegalArgumentException("no env-entry of name " + name);
    }

    @Override
    public void addEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.environmentProperties.add(environmentProperty);
    }

    @Override
    public void removeEnvironmentProperty(EnvironmentProperty environmentProperty) {
        this.environmentProperties.remove(environmentProperty);
    }

    public Set<EjbInterceptor> getInterceptors() {
        return new HashSet<EjbInterceptor>(this.interceptors.values());
    }

    public EjbInterceptor getInterceptorByClassName(String className) {
        return this.interceptors.get(className);
    }

    public void addInterceptor(EjbInterceptor interceptor) {
        EjbInterceptor ic = this.getInterceptorByClassName(interceptor.getInterceptorClassName());
        if (ic == null) {
            interceptor.setEjbBundleDescriptor(this);
            this.interceptors.put(interceptor.getInterceptorClassName(), interceptor);
        }
    }

    @Override
    public Set<MessageDestinationReferenceDescriptor> getMessageDestinationReferenceDescriptors() {
        return this.messageDestReferences;
    }

    @Override
    public MessageDestinationReferenceDescriptor getMessageDestinationReferenceByName(String name) {
        for (MessageDestinationReferenceDescriptor mdr : this.messageDestReferences) {
            if (!mdr.getName().equals(name)) continue;
            return mdr;
        }
        throw new IllegalArgumentException("No message destination ref of name " + name);
    }

    @Override
    public void addMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor messageDestRef) {
        messageDestRef.setReferringBundleDescriptor(this);
        this.messageDestReferences.add(messageDestRef);
    }

    @Override
    public void removeMessageDestinationReferenceDescriptor(MessageDestinationReferenceDescriptor msgDestRef) {
        this.messageDestReferences.remove(msgDestRef);
    }

    @Override
    public Set<ResourceEnvReferenceDescriptor> getResourceEnvReferenceDescriptors() {
        return this.resourceEnvReferences;
    }

    @Override
    public ResourceEnvReferenceDescriptor getResourceEnvReferenceByName(String name) {
        for (ResourceEnvReferenceDescriptor element : this.resourceEnvReferences) {
            if (!element.getName().equals(name)) continue;
            return element;
        }
        throw new IllegalArgumentException("No resource env ref of name " + name);
    }

    @Override
    public void addResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        this.resourceEnvReferences.add(resourceEnvReference);
    }

    @Override
    public void removeResourceEnvReferenceDescriptor(ResourceEnvReferenceDescriptor resourceEnvReference) {
        this.resourceEnvReferences.remove(resourceEnvReference);
    }

    @Override
    public Set<ResourceReferenceDescriptor> getResourceReferenceDescriptors() {
        return this.resourceReferences;
    }

    @Override
    public ResourceReferenceDescriptor getResourceReferenceByName(String name) {
        for (ResourceReferenceDescriptor reference : this.resourceReferences) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException("No resource ref of name " + name);
    }

    @Override
    public void addResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.add(resourceReference);
    }

    @Override
    public void removeResourceReferenceDescriptor(ResourceReferenceDescriptor resourceReference) {
        this.resourceReferences.remove(resourceReference);
    }

    @Override
    public Set<ServiceReferenceDescriptor> getServiceReferenceDescriptors() {
        return this.serviceReferences;
    }

    @Override
    public ServiceReferenceDescriptor getServiceReferenceByName(String name) {
        for (ServiceReferenceDescriptor reference : this.getServiceReferenceDescriptors()) {
            if (!reference.getName().equals(name)) continue;
            return reference;
        }
        throw new IllegalArgumentException("No service ref of name " + name);
    }

    @Override
    public void addServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        serviceRef.setBundleDescriptor(this);
        this.serviceReferences.add(serviceRef);
    }

    @Override
    public void removeServiceReferenceDescriptor(ServiceReferenceDescriptor serviceRef) {
        this.serviceReferences.remove(serviceRef);
    }

    @Override
    public void removeRole(Role role) {
        LOG.log(System.Logger.Level.DEBUG, "removeRole(role={0})", role);
        if (this.getRoles().contains(role)) {
            for (EjbDescriptor ejb : this.ejbs) {
                ejb.removeRole(role);
            }
            super.removeRole(role);
        }
    }

    @Override
    public ComponentVisitor getBundleVisitor() {
        return null;
    }

    @Override
    public List<InjectionCapable> getInjectableResourcesByClass(String className) {
        return this.getInjectableResourcesByClass(className, this);
    }

    @Override
    public InjectionInfo getInjectionInfoByClass(Class<?> clazz) {
        return this.getInjectionInfoByClass(clazz, this);
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPostConstructDescriptors() {
        return Collections.emptySet();
    }

    @Override
    public void addPostConstructDescriptor(LifecycleCallbackDescriptor postConstructDesc) {
    }

    @Override
    public LifecycleCallbackDescriptor getPostConstructDescriptorByClass(String className) {
        return null;
    }

    @Override
    public Set<LifecycleCallbackDescriptor> getPreDestroyDescriptors() {
        return Collections.emptySet();
    }

    @Override
    public void addPreDestroyDescriptor(LifecycleCallbackDescriptor preDestroyDesc) {
    }

    @Override
    public LifecycleCallbackDescriptor getPreDestroyDescriptorByClass(String className) {
        return null;
    }
}

