/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.server;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Enumeration;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.hk2.classmodel.reflect.ArchiveAdapter;
import org.glassfish.hk2.classmodel.reflect.Parser;
import org.glassfish.hk2.classmodel.reflect.util.AbstractAdapter;
import org.glassfish.kernel.KernelLoggerInfo;

public class ReadableArchiveScannerAdapter
extends AbstractAdapter
implements AutoCloseable {
    final ReadableArchive archive;
    final Parser parser;
    final URI uri;
    final ReadableArchiveScannerAdapter parent;
    final AtomicInteger releaseCount = new AtomicInteger(1);
    private static final Level level = Level.FINE;
    private static final Logger alogger = KernelLoggerInfo.getLogger();

    public ReadableArchiveScannerAdapter(Parser parser, ReadableArchive archive) {
        this.archive = archive;
        this.parser = parser;
        this.uri = archive.getURI();
        this.parent = null;
    }

    private ReadableArchiveScannerAdapter(ReadableArchiveScannerAdapter parent, ReadableArchive archive, URI uri) {
        this.parent = parent;
        this.archive = archive;
        this.parser = parent.parser;
        this.uri = uri == null ? archive.getURI() : uri;
    }

    public URI getURI() {
        return this.uri;
    }

    public Manifest getManifest() throws IOException {
        return this.archive.getManifest();
    }

    public void onSelectedEntries(ArchiveAdapter.Selector selector, ArchiveAdapter.EntryTask entryTask, Logger logger) throws IOException {
        Enumeration entries = this.archive.entries();
        while (entries.hasMoreElements()) {
            String name = (String)entries.nextElement();
            ArchiveAdapter.Entry entry = new ArchiveAdapter.Entry(name, this.archive.getEntrySize(name), false);
            if (selector.isSelected(entry)) {
                this.handleEntry(name, entry, logger, entryTask);
            }
            if (!name.endsWith(".jar")) continue;
            this.handleJar(name, logger);
        }
        logger.log(level, () -> "Finished parsing " + String.valueOf(this.uri));
    }

    @Override
    public void close() throws IOException {
        this.releaseCount();
    }

    private void releaseCount() throws IOException {
        int release = this.releaseCount.decrementAndGet();
        if (release == 0) {
            this.archive.close();
            if (this.parent != null) {
                this.parent.releaseCount();
            }
        }
    }

    protected void handleEntry(String name, ArchiveAdapter.Entry entry, Logger logger, ArchiveAdapter.EntryTask entryTask) throws IOException {
        try (InputStream is = this.archive.getEntry(name);){
            if (is == null) {
                alogger.log(Level.SEVERE, "NCLS-CORE-00048", name);
                return;
            }
            entryTask.on(entry, is);
        }
        catch (Exception e) {
            alogger.log(Level.SEVERE, "NCLS-CORE-00049", new Object[]{entry.name, this.archive.getURI(), entry.size, e});
        }
    }

    protected Future<Parser.Result> handleJar(final String name, final Logger logger) throws IOException {
        String explodedName = name.replaceAll("[/ ]", "__").replace(".jar", "_jar");
        if (!this.archive.exists(explodedName)) {
            final ReadableArchive subArchive = this.archive.getSubArchive(name);
            if (subArchive == null) {
                logger.log(Level.SEVERE, "NCLS-CORE-00050", new Object[]{name, this.archive.getURI()});
                return null;
            }
            logger.log(level, () -> "Spawning sub parsing " + String.valueOf(subArchive.getURI()));
            final InternalJarAdapter adapter = new InternalJarAdapter(this, subArchive, subArchive.getURI());
            this.releaseCount.incrementAndGet();
            return this.parser.parse((ArchiveAdapter)adapter, new Runnable(){

                @Override
                public void run() {
                    try {
                        logger.log(level, () -> "Closing sub archive " + String.valueOf(subArchive.getURI()));
                        adapter.close();
                    }
                    catch (IOException e) {
                        logger.log(Level.SEVERE, "NCLS-CORE-00051", new Object[]{name, e});
                    }
                }
            });
        }
        return null;
    }

    private static class InternalJarAdapter
    extends ReadableArchiveScannerAdapter {
        public InternalJarAdapter(ReadableArchiveScannerAdapter parent, ReadableArchive archive, URI uri) {
            super(parent, archive, uri);
        }

        @Override
        protected Future<Parser.Result> handleJar(String name, Logger logger) throws IOException {
            return null;
        }
    }
}

